Require booleans.
Require actions.

(* ======================================================================== *)
(*                        MuCRL 		                            *)
(* ======================================================================== *)

Parameter proc :Set.
Parameter ia : (D:Set)act->D->proc.

Parameter act_of:proc->act. 
Axiom act_of_act: (D:Set)(d:D)(a:act)<act>(act_of (ia D a d))=a.

Axiom proc_equal_if_data_eql:
(D:Set)(p:D->proc)(d,e:D)<bool>(eql D d e)=true-><proc>(p d)=(p e).

Definition Delta = (ia one delta i).
Definition Tau   = (ia one tau i).

Axiom Delta_Data: (D:Set)(d:D)<proc>Delta=(ia D delta d).
Axiom Tau_Data:   (D:Set)(d:D)<proc>Tau=(ia D tau d).

Hint Unfold Delta Tau.

Hint Unfold Delta Tau.

Definition ehset = act->Prop.
Definition goodset: (act->Prop)->act->Prop = 
	[L:act->Prop][a:act](~(<act>a=delta))/\(~(<act>a=tau))/\(L a).
(* characteristic function of a set of actions, *)
(* as used for encapsulation and hiding		*)
(* delta and tau must cannot be in this set     *)

Parameter alt  :proc->proc->proc.
Parameter seq  :proc->proc->proc.
Parameter mer  :proc->proc->proc.
Parameter Lmer :proc->proc->proc.
Parameter comm :proc->proc->proc.
Parameter cond :proc->bool->proc->proc.
Parameter sum  :(D:Set)(D->proc)->proc.
Parameter enc  :ehset->proc->proc.
Parameter hide :ehset->proc->proc.
Parameter GRD  :proc->Prop.

Section COMMUNICATION_F.
Variable a,b:act.
Variable E,F:Set.
Variable e,e1,e2:E.
Variable f:F.
Axiom CF1: <proc>(cond (ia E (gamma a b) e1) (eql E e1 e2) Delta)=
		 (comm (ia E a e1) (ia E b e2)).
Axiom CF2: ~(EQL E F)-><proc>Delta=(comm (ia E a e) (ia F b f)).
End COMMUNICATION_F.

Section BPA.
Variable x,y,z:proc.
Axiom A1: <proc>(alt x y)=(alt y x).
Axiom A2: <proc>(alt x (alt y z))=(alt (alt x y) z).
Axiom A3: <proc>x=(alt x x).
Axiom A4: <proc>(alt (seq x z) (seq y z))=(seq (alt x y) z).
Axiom A5: <proc>(seq x (seq y z))=(seq (seq x y) z).
Axiom A6: <proc>x=(alt x Delta).
Axiom A7: <proc>Delta=(seq Delta x).
End BPA.

Section PARALLEL_OPERATORS.
Variable x,y,z:proc.
Variable E,F:Set.
Variable e:E.
Variable f:F.
Variable a,b  :act.
Axiom CM1: <proc>(alt (alt (Lmer x y) (Lmer y x)) (comm x y))=(mer x y).
Axiom CM2: <proc>(seq (ia E a e) x)=(Lmer (ia E a e) x).
Axiom CM3: <proc>(seq (ia E a e) (mer x y))=(Lmer (seq (ia E a e) x) y).
Axiom CM4: <proc>(alt (Lmer x z) (Lmer y z))=(Lmer (alt x y) z).
Axiom CM5: <proc>(seq (comm (ia E a e) (ia F b f)) x)=
                         (comm (seq (ia E a e) x) (ia F b f)).
Axiom CM6: <proc>(seq (comm (ia E a e) (ia F b f)) x)=
                         (comm (ia E a e) (seq (ia F b f) x)).
Axiom CM7: <proc>(seq (comm (ia E a e) (ia F b f)) (mer x y))=
                         (comm (seq (ia E a e) x) (seq (ia F b f) y)).
Axiom CM8: <proc>(alt (comm x z) (comm y z))=(comm (alt x y) z).
End PARALLEL_OPERATORS.

Section STANDARD_CONCURRENCY.
Variable x,y,z:proc.
Axiom SC1: <proc>(Lmer x (mer y z))=(Lmer (Lmer x y) z).
Axiom SC3: <proc>(comm y x)=(comm x y).
Axiom SC5: <proc>(Lmer (comm x y) z)=(comm x (Lmer y z)).
Axiom Handshaking: <proc>Delta=(comm x (comm y z)).
Axiom commDelta: <proc>Delta=(comm Delta x).
Axiom commTau  : <proc>Delta=(comm Tau   x).
End  STANDARD_CONCURRENCY.

Section CONDITION.
Variable x,y:proc.
Axiom COND1: <proc>x=(cond x true y).
Axiom COND2: <proc>y=(cond x false y).
End CONDITION.

Section SUM.
Variable D    :Set.
Variable d    :D.
Variable p,q  :D->proc.
Variable x    :proc.
Variable L    :ehset.
Axiom SUM1.  Assumes <proc>x=(sum D ([d:D]x)).
Axiom SUM3.  Assumes <proc>(alt (sum D p) (p d))=(sum D p).
Axiom SUM4.  Assumes <proc>(sum D ([d:D](alt (p d) (q d))))=
                           (alt (sum D p) (sum D q)).
Axiom SUM5.  Assumes <proc>(sum D ([d:D](seq (p d) x)))=
                            (seq (sum D p ) x).
Axiom SUM6.  Assumes <proc>(sum D ([d:D](Lmer (p d) x)))=
                           (Lmer (sum D p) x).
Axiom SUM7.  Assumes <proc>(sum D ([d:D](comm (p d) x)))=
                           (comm (sum D p) x).
Axiom SUM8.  Assumes <proc>(sum D ([d:D](hide L (p d))))=(hide L (sum D p)).
Axiom SUM9.  Assumes <proc>(sum D ([d:D](enc L (p d))))=(enc L (sum D p)).
Axiom SUM11: ((d:D)<proc>(p d)=(q d))-><proc>(sum D p)=(sum D q).
End SUM.

Section HIDE.
Variable x,y:proc.
Variable E  :Set.
Variable e  :E.
Variable a  :act.
Variable L  :ehset.
Axiom TI1: (~(goodset L a))->
                    (<proc>(ia E a e)=(hide L (ia E a e))).
Axiom TI2: (goodset L a)->
                    (<proc>(ia one tau i)=(hide L (ia E a e))).
Axiom TI3: <proc>(alt (hide L x) (hide L y))=(hide L (alt x y)).
Axiom TI4: <proc>(seq (hide L x) (hide L y))=(hide L (seq x y)).
Axiom TAU1: <proc>x=(seq x Tau).
End HIDE.

Section ENCAPSULATION.
Variable x,y:proc.
Variable E  :Set.
Variable e  :E.
Variable a  :act.
Variable L  :ehset.
Axiom D1: (~(goodset L a))->(<proc>(ia E a e)=(enc L (ia E a e))).
Axiom D2: (goodset L a)->(<proc>Delta=(enc L (ia E a e))).
Axiom D3: <proc>(alt (enc L x) (enc L y))=(enc L (alt x y)).
Axiom D4: <proc>(seq (enc L x) (enc L y))=(enc L (seq x y)).
End ENCAPSULATION.

Section GUARDED.
Variable D  :Set.
Variable d  :D.
Variable x,y:proc.
Variable p  :D->proc.
Variable a  :act.
Variable B  :bool.
Variable L  :ehset.
Axiom G2.  Assumes ~(<act>a=tau)->(GRD (ia D a d)).
Axiom G5.  Assumes ((d:D)(GRD (p d)))->(GRD (sum D p)).
Axiom G6.  Assumes (GRD x)->(GRD (seq x y)).
Axiom G7.  Assumes (GRD x)->(GRD (Lmer x y)).
Axiom G8.  Assumes (GRD x)->(GRD y)->(GRD (alt x y)).
Axiom G9.  Assumes (GRD x)->(GRD y)->(GRD (mer x y)).
Axiom G11: (GRD x)->(GRD y)->(GRD (cond x B y)).
Axiom G13: (GRD x)->(GRD (enc L x)).
End GUARDED.

Hint G2 G5 G6 G7 G8 G9 G11 G13.

Axiom RSP: (D:Set)(x,y:D->proc)(G:(D->proc)->D->proc)
                   ((p:D->proc)(d:D)(GRD (G p d)))->
                   ((d:D)<proc>(x d)=(G x d))->((d:D)<proc>(y d)=(G y d))->
                   (d:D)<proc>(x d)=(y d).

Section CFAR. 
Variable I':ehset.
Variable Nr:Set.
Variable X,Out:Nr->proc.
Variable Int:Nr->Nr->proc.
Variable int:Nr->Nr->act.

Inductive Definition Reach:Nr->Nr->Prop
= reach1:(n,n':Nr)(I' (int n n'))->(Reach n n')
| reacht:(n,n',n'':Nr)(Reach n' n)->(Reach n n'')->(Reach n' n'').

Inductive Definition TauReach:Nr->Nr->Prop
= taureach1:(n,n':Nr)<act>(int n n')=tau->(TauReach n n')
| taureacht:(n,n',n'':Nr)(TauReach n n')->(TauReach n' n'')->(TauReach n n').

Axiom CFAR:
((n,n':Nr) (I' (int n n')) \/ <act>(int n n')=delta)->
((n,n':Nr) (Reach n n'))->
((n:Nr)   ~(TauReach n n))->
((n,n':Nr) <act>(int n n')=(act_of (Int n n')))->
((n:Nr)	   <proc>(X n)=(alt (sum Nr [n':Nr](seq (Int n n') (X n')))
			   (Out n)				   ))->
(n:Nr) <proc>(seq Tau (hide I' (X n)))=
	     (seq Tau (sum Nr [n:Nr] (hide I' (Out n)))).

Goal (* no tau-steps in cluster before hiding *)
((n,n':Nr) (I' (int n n')) \/ <act>(int n n')=delta)->
((n,n':Nr) (Reach n n'))->
((n,n':Nr)~(<act>tau=(int n n')))->
((n,n':Nr) <act>(int n n')=(act_of (Int n n')))->
((n:Nr)	   <proc>(X n)=(alt (sum Nr [n':Nr](seq (Int n n') (X n')))
			   (Out n)				   ))->
(n:Nr) <proc>(seq Tau (hide I' (X n)))=
	     (seq Tau (sum Nr [n:Nr] (hide I' (Out n)))).
Intros.
Apply CFAR;Try Assumption.
Intro;Red;Intro.
Elim H4;Intros.	
	Apply (H1 n1 n').
	Apply sym_equal;Assumption.
Assumption.
Save CFARmin.
End CFAR.

(* ======================================================================== *)
(*                    Extra axiomas en wat theorie                          *)
(* ======================================================================== *)

Goal (D,D':Set)(d:D)(d':D')(a,a':act)
	<proc>(ia D a d)=(ia D' a' d')->(<act>a=a').
Intros.
Replace a with (act_of (ia D a d)).
	Replace a' with (act_of (ia D' a' d')).
		Apply (f_equal proc act act_of).
		Assumption.
	Rewrite act_of_act; Apply refl_equal.
Rewrite act_of_act; Apply refl_equal.
Save same_act.

Goal (L:ehset)(a:act)~(L a)->~(goodset L a).
Unfold goodset.
Intros;Red;Intro.
Elim H0;Intros.
Elim H2;Intro.
Assumption.
Save not_goodset.

Hint not_goodset.

Section DERIVED.
Variable D:Set.
Variable d,e:D.
Variable OP:proc->proc->proc.
Variable b,c:bool.
Variable x,y,z,w:proc.
Variable a:act.

Goal <proc>(ia D a d)=Tau-><act>a=tau.
Intros.
Apply (same_act D one d i).
Apply H.
Save act_istau.

Goal <proc>x=(alt Delta x).
Elim A1.
Apply A6.
Save A6'.

Goal <proc>Delta=(comm x Delta).
Elim SC3.
Apply commDelta.
Save commDelta'.

Goal <proc>Delta=(Lmer Delta x).
Unfold Delta.
Elim CM2.
Apply A7.
Save CM2'.

Goal <proc>(alt (comm x y) (comm x z))=(comm x (alt y z)).
Elim SC3.
Elim CM8.
Elim (SC3 x y).
Elim (SC3 x z).
Apply refl_equal.
Save CM9.

Goal <proc>Delta=(comm (comm x y) z).
Elim SC3.
Apply Handshaking.
Save Handshaking'.

Goal (<bool>(eql D d e)=true-><proc>x=y)->
			   <proc>z=w ->
	<proc>(cond x (eql D d e) z)=(cond y (eql D d e) w).
Intros.
(Elim (EM_bool (eql D d e));
[Intro H1;Elim H ;Rewrite H1;Repeat Elim COND1
|Intro H1;Elim H0;Rewrite H1;Repeat Elim COND2]);
Auto.
Save Split_COND.

Goal <proc>x=(cond x b x).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND3.

Goal <proc>(cond x b y)=(cond y (neg b) x).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND4.

Goal <proc>(cond (OP x z) b (OP y z))=(OP (cond x b y) z).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND5.

Goal <proc>(cond (OP x y) b (OP x z))=(OP x (cond y b z)).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND5'.

Goal <proc>(alt (cond x b z) (cond y b z))=(cond (alt x y) b z).
Elim (EM_bool b);Intro H0.
Do 3 (Rewrite H0;Elim COND1);Apply refl_equal.
Do 3 (Rewrite H0;Elim COND2);Elim A3;Apply refl_equal.
Save COND6.

Goal <proc>(alt (cond z b x) (cond z b y))=(cond z b (alt x y)).
Elim (EM_bool b);Intro H0.
Do 3 (Rewrite H0;Elim COND1);Elim A3;Apply refl_equal.
Do 3 (Rewrite H0;Elim COND2);Apply refl_equal.
Save COND6'.

Goal <bool>b=c-><proc>(cond x b z)=(cond x b (cond y c z)).
Intro H'.
Elim H'.
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND7.

Goal <bool>b=c-><proc>(cond y b x)=(cond (cond y c z) b x).
Intro H'.
Elim H'.
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND7'.
End DERIVED.

Section DERIVED2.
Variable b,c:bool.
Variable x,y,z:proc.
Variable D:Set.
Variable p,q:D->proc.
Variable I':ehset.

Goal <bool>b=(neg c)-><proc>(cond x b y)=(cond x b (cond y c z)).
Intros.
Rewrite (COND4 c).
Apply COND7.
Assumption.
Save COND8.

Goal (x,y,z:proc)(b,c:bool)
<bool>b=(neg c)-><proc>(cond z b x)=(cond (cond y c z) b x).
Intros.
Rewrite (COND4 c).
Apply COND7'.
Assumption.
Save COND8'.

Goal <proc>(sum D [d:D](cond (p d) b y))=(cond (sum D p) b y).
Elim (EM_bool b);Intro H0;Rewrite H0. 
	Elim COND1.
	Apply SUM11;Intro.
	Elim COND1;Apply refl_equal.
Elim COND2.
Rewrite (SUM1 D y).
Apply SUM11;Intro.
Elim COND2;Apply refl_equal.
Save COND9.

Goal <proc>(sum D [d:D](cond y b (p d)))=(cond y b (sum D p)).
Elim (EM_bool b);Intro H0;Rewrite H0.
        Elim COND1. 
	Rewrite (SUM1 D y). 
        Apply SUM11;Intro. 
        Elim COND1;Apply refl_equal. 
Elim COND2.
Apply SUM11;Intro.
Elim COND2;Apply refl_equal.
Save COND9'.

Goal <proc>(sum D [d:D](cond (q d) b (p d)))=(cond (sum D q) b (sum D p)).
Elim (EM_bool b);Intro H0;Rewrite H0.
        Elim COND1. 
        Apply SUM11;Intro. 
        Elim COND1;Apply refl_equal. 
Elim COND2.
Apply SUM11;Intro.
Elim COND2;Apply refl_equal.
Save COND9''.

Goal <proc>(cond (enc I' x) b (enc I' y))=(enc I' (cond x b y)).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND10.

Goal <proc>(cond (hide I' x) b (hide I' y))=(hide I' (cond x b y)).
Load "$COQTH/CONTRIB/Eindhoven/ABP/condtac".
Save COND11.

Goal <proc>(sum D ([d:D](comm x (p d))))=(comm x (sum D p)).
Elim SC3.
Elim SUM7.
Apply SUM11.
Intro.
Apply SC3.
Save SUM7'.

Goal <proc>(comm x (comm y z))=(comm (comm x y) z).
Elim Handshaking.
Apply Handshaking'.
Save SC4.

Goal <proc>(mer x y)=(mer y x).
Elim CM1.
Elim CM1.
Elim SC3.
Elim (A1 (Lmer x y) (Lmer y x)).
Apply refl_equal.
Save SC6.

Goal <proc>Delta=(hide I' Delta).
Unfold Delta.
Apply TI1.
Unfold goodset.
Hnf;Intro.
Elim H;Intros.
Apply H0.
Apply refl_equal.
Save TI1_Delta.

Goal <proc>Delta=(enc I' Delta).
Unfold Delta.
Apply D1.
Unfold goodset.
Hnf;Intro.
Elim H;Intros.
Apply H0.
Apply refl_equal.
Save D1_Delta.
End DERIVED2.

Goal (D,E:Set)(p:D->proc)(q:E->proc)
	<proc>(sum D [d:D](sum E [e:E](comm (p d) (q e))))=
	      (comm (sum D p) (sum E q)).
Intros.
Elim SUM7.
Apply SUM11;Intro.
Apply SUM7'.
Save SUM7''.

Goal (x,y,z:proc)<proc>(mer x (mer y z))=(mer (mer x y) z).
Intros.
Repeat Elim CM1.
Repeat Elim SC1.
Repeat Elim CM8.
Repeat Elim CM9.
Repeat Elim CM4.
Repeat Elim SC5.
Repeat Elim SC4.
Repeat Elim CM1.
Repeat Elim A2.
Repeat Elim SC1.
Repeat Elim CM1.
Elim (A1  (Lmer z x) (Lmer x z)).
Repeat Elim A2.
Elim (SC3 x z).
ElimType <proc> (alt (Lmer z (alt (Lmer y x) (alt (Lmer x y) (comm y x))))
            (alt (Lmer (comm y z) x)
               (alt (Lmer (comm x y) z)
                  (alt (Lmer (comm z x) y) (comm x (comm y z))))))=
            (alt (Lmer (comm x y) z)
              (alt (Lmer z (alt (Lmer x y) (alt (Lmer y x) (comm x y))))
               (alt (comm (Lmer x y) z)
                  (alt (comm (Lmer y x) z) (comm x (comm y z)))))).
Apply refl_equal.
Elim (A1
      (alt (Lmer z (alt (Lmer x y) (alt (Lmer y x) (comm x y))))
         (alt (comm (Lmer x y) z)
            (alt (comm (Lmer y x) z) (comm x (comm y z)))))
                   (Lmer (comm x y) z)).
Repeat Elim A2.
ElimType <proc> (alt (Lmer (comm y z) x)
         (alt (Lmer (comm x y) z)
            (alt (Lmer (comm z x) y) (comm x (comm y z)))))=
                (alt (comm (Lmer x y) z)
         (alt (comm (Lmer y x) z)
            (alt (comm x (comm y z)) (Lmer (comm x y) z)))).
ElimType <proc> (alt (Lmer y x) (alt (Lmer x y) (comm y x)))=
              (alt (Lmer x y) (alt (Lmer y x) (comm x y))).
Apply refl_equal.
Elim SC3.
Elim A1.
Elim A2.
Elim A1.
Elim A2.
Elim (A1 (Lmer y x) (Lmer x y)).
Elim A1.
Elim A2.
Apply refl_equal.
Elim (SC3 (Lmer y x) z).
Elim SC5.
Elim (A1  (alt (Lmer (comm z y) x)
         (alt (comm x (comm y z)) (Lmer (comm x y) z))) (comm (Lmer x y) z)).
Repeat Elim A2.
ElimType <proc> (alt (Lmer (comm x y) z)
         (alt (Lmer (comm z x) y) (comm x (comm y z))))=
            (alt (comm x (comm y z))
         (alt (Lmer (comm x y) z) (comm (Lmer x y) z))).
Elim (SC3 y z).
Apply refl_equal.
Elim (A1  (alt (Lmer (comm x y) z) (comm (Lmer x y) z)) (comm x (comm y z))).
Elim A2.
Elim (SC3 (Lmer x y) z).
Elim SC5.
Apply refl_equal.
Save SC7.

(* ======================================================================== *)
(*                            Expansies                                     *)
(* ======================================================================== *)

Goal (x,y:proc)<proc>(alt (Lmer x y) (alt (Lmer y x) (comm x y)))=(mer x y).
Intros.
Elim CM1.
Elim A2.
Auto.
Save EXP2.

Goal (x,y,z:proc)<proc>
     (alt (Lmer x (mer y z))
      (alt (Lmer y (mer x z))
       (alt (Lmer z (mer x y))
        (alt (Lmer (comm y z) x)
         (alt (Lmer (comm x y) z)
              (Lmer (comm x z) y))))))
      =(mer x (mer y z)).
Intros.
Elim EXP2.
Elim EXP2.
Repeat Elim CM4.
Repeat Elim SC1.
Repeat Elim CM9.
Repeat Elim Handshaking.
Repeat Elim SC5.
Repeat Elim A6.
Repeat Elim A2.
Elim (SC6 x y).
Elim (SC6 x z).
Rewrite EXP2.
Auto.
Save EXP3.

Goal (x,y,z,u:proc)<proc>
   (alt (Lmer x (mer y (mer z u)))
      (alt (Lmer y (mer x (mer z u)))
         (alt (Lmer z (mer x (mer y u)))
            (alt (Lmer u (mer x (mer y z)))
               (alt (Lmer (comm z u) (mer x y))
                  (alt (Lmer (comm y z) (mer x u))
                     (alt (Lmer (comm y u) (mer x z))
                        (alt (Lmer (comm x y) (mer z u))
                           (alt (Lmer (comm x z) (mer y u))
                              (Lmer (comm x u) (mer y z)))))))))))
   =(mer x (mer y (mer z u))).
Intros.
Elim EXP2.
Elim EXP3.
Repeat Elim CM4.
Repeat Elim SC1.
Repeat Elim CM9.
Repeat Elim SC5.
Repeat Elim Handshaking.
Repeat Elim CM2'.
Repeat Elim A6.
Repeat Elim A2.
Elim (SC6 x (mer z u)).
Elim (SC6 x (mer y u)).
Elim (SC6 x (mer y z)).
Elim (SC6 x u).
Elim (SC6 x y).
Elim (SC6 x z).
Elim (SC6 y z).
Auto.
Save EXP4.

Goal (x,y,z,u,v:proc)<proc>
   (alt (Lmer x (mer y (mer z (mer u v))))
     (alt (Lmer y (mer x (mer z (mer u v))))
       (alt (Lmer z (mer x (mer y (mer u v))))
         (alt (Lmer u (mer x (mer y (mer z v))))
           (alt (Lmer v (mer x (mer y (mer z u))))
             (alt (Lmer (comm u v) (mer x (mer y z)))
               (alt (Lmer (comm z u) (mer x (mer y v)))
                 (alt (Lmer (comm z v) (mer x (mer y u)))
                   (alt (Lmer (comm y z) (mer x (mer u v)))
                     (alt (Lmer (comm y u) (mer x (mer z v)))
                       (alt (Lmer (comm y v) (mer x (mer z u)))
                         (alt (Lmer (comm x y) (mer z (mer u v)))
                           (alt (Lmer (comm x z) (mer y (mer u v)))
                             (alt (Lmer (comm x u) (mer y (mer z v)))
                               (Lmer (comm x v) (mer y (mer z u)))
    ))))))))))))))
   =(mer x (mer y (mer z (mer u v)))).
Intros.
Elim EXP4.
Pattern 10 11 13 16 (mer u v).
Elim EXP2.
Repeat Elim CM4.
Repeat Elim SC1.
Repeat Elim CM9.
Repeat Elim SC5.
Repeat Elim Handshaking.
Repeat Elim CM2'.
Repeat Elim A6.
Repeat Elim A2.
Repeat Elim CM4.
Repeat Elim SC1.
Repeat Elim A2.
Elim (SC6 (mer x (mer y z)) v).
Elim (SC6 (mer x (mer y z)) u).
Elim (SC6 (mer x y) v).
Elim (SC6 (mer x z) v).
Elim (SC6 (mer x z) u).
Elim (SC6 (mer x y) u).
Elim (SC6 (mer y z) v).
Elim (SC6 (mer y z) u).
Repeat Elim SC7.
Auto.
Save EXP5.

(* ======================================================================== *)
(*                    Axiomas als regels	                            *)
(* ======================================================================== *)

Section RULES.
Variable b:bool.
Variable x,y,z,w:proc.
Variable D:Set.
Variable p:D->proc.
Variable L:ehset.

Goal <proc>z=x-><proc>w=y-><proc>(alt z w)=(alt x y).
Intros Hx Hy.
Elim Hx;Elim Hy.
Apply refl_equal.
Save Split_alt.

Goal <proc>z=x-><proc>z=y-><proc>z=(alt y x).
Intros Hx Hy.
Elim Hx;Elim Hy.
Apply A3.
Save RuleA3.

Goal <proc>Delta=x-><proc>z=y-><proc>z=(alt y x).
Intros Hx Hy.
Elim Hx;Elim Hy.
Apply A6.
Save RuleA6.

Goal <proc>Delta=x-><proc>z=y-><proc>z=(alt x y).
Intros Hx Hy.
Elim Hx;Elim Hy.
Apply A6'.
Save RuleA6'.

Goal <proc>Delta=x-><proc>Delta=(seq x y).
Intro Hx.
Elim Hx.
Apply A7.
Save RuleA7.

Goal <bool>true=b-><proc>x=(cond x b y).
Intro Hb.
Elim Hb.
Apply COND1.
Save RuleCOND1.

Goal <bool>false=b-><proc>y=(cond x b y).
Intro Hb.
Elim Hb.
Apply COND2.
Save RuleCOND2.

Goal ((d:D)<proc>x=(p d))-><proc>x=(sum D p).
Intro.
Replace x with (sum D [d:D]x).
	Apply SUM11;Assumption.
Elim SUM1;Apply refl_equal.
Save RuleSUM1.

Goal <proc>Delta=x-><proc>Delta=(hide L x).
Intro Hx.
Elim Hx.
Apply TI1_Delta.
Save RuleTI1_Delta.

Goal <proc>Delta=x-><proc>Delta=(enc L x).
Intro Hx.
Elim Hx.
Apply D1_Delta.
Save RuleD1_Delta.
End RULES.

Goal (D:Set)(p:D->proc)(d,e:D)
<proc>(alt (p e) (cond Delta (eql D d e) (p d)))=(alt (p e) (p d)).
Intros.
Elim (EM_bool (eql D d e));Intro H0.
	Rewrite H0.
	Elim COND1.
	Elim A6.
	Replace (p e) with (p d).
		Apply A3.
	Apply (proc_equal_if_data_eql D p);Assumption.
Rewrite H0.
Elim COND2.
Apply refl_equal.
Save CONDeq.

Goal (D:Set)(e:D)(p:D->proc)
<proc>(sum D p)=(alt (p e) (sum D [d:D](cond Delta (eql D d e) (p d)))).
Intros.
Replace (sum D p) with (alt (p e) (sum D p)). 
	2:Elim A1;Apply SUM3.
Replace (p e) with (sum D [d:D](p e)).
	2:Elim SUM1;Auto.
Repeat Elim SUM4.
Apply SUM11.
Intro.
Apply sym_equal;Apply CONDeq.
Save SUMmand.

Goal (D:Set)(x:proc)(e:D)
<proc>x=(sum D [d:D](cond x (eql D d e) Delta)).
Intros.
Rewrite (SUMmand D e).
Rewrite refl_eql.
Elim COND1.
Apply RuleA6.
	2:Auto.
Apply RuleSUM1.
Intro.
Elim (EM_bool (eql D d e));Intro H0.
	Repeat (Rewrite H0;Elim COND1);Auto.
Repeat (Rewrite H0;Elim COND2);Auto.
Save SUMrep.

Goal (D:Set)(e:D)(x:proc)(p:D->proc)
((d:D)<proc>(cond x (eql D d e) Delta)=(p d))-><proc>x=(sum D p).
Intros.
Rewrite (SUMrep D x e).
Apply SUM11;Intro.
Rewrite H.
Apply refl_equal.
Save RuleSUMrep.

Goal (b:bool)(p:bool->proc)<proc>(alt (p b) (p (neg b)))=(sum bool p).
Intros.
Rewrite (SUMmand bool b).
Apply (f_equal proc proc (alt (p b))).
Apply (RuleSUMrep bool (neg b)).
Induction d;Elim b;Unfold neg;Rewrite refl_eql;Elim COND1;
Rewrite not_eql_true_false; Try (Rewrite sym_eql;Rewrite not_eql_true_false);
Elim COND2;Apply refl_equal.
Save EXP_bool_SUM.

Provide muCRL.
