(* ======================================================================== *)
(*				Trivia					    *)
(* ======================================================================== *)

Goal ~False.
Red;Auto.
Save truth.

Hint truth.

Goal (P:Prop)P->True->P.
Auto.
Save void.

(* ======================================================================== *)
(*				booleans				    *)
(* ======================================================================== *)

(* Difference and Excluded Middle for the booleans *)

Goal ~(<bool>true=false).
Red;Intro H.
Change (<Prop>Match false with True False).
Elim H.
Exact I.
Save diff_true_false.

Goal (b:bool)(<bool>b=true)\/(<bool>b=false).
Induction b;Auto.
Save EM_bool.

(* Negation *)
Definition neg=[b:bool](<bool>Match b with false true).

Hint Unfold neg.

Goal (b:bool)<bool>(neg (neg b))=b.
Induction b;Auto.
Save negs.

Section EQUALITY.
(* equality of datatypes and inhabitants of datatypes *)
Variable D,E,F:Set.
Variable d,e,f:D.

Parameter eql  : D->D->bool.
Axiom refl_eql : <bool>(eql d d)=true.
Axiom sym_eql  : <bool>(eql d e)=(eql e d).
Axiom trans_eql: <bool>(eql d e)=true-><bool>(eql e f)=(eql f d).

Parameter EQL  : Set->Set->Prop.
Axiom refl_EQL : (EQL D D).
Axiom sym_EQL  : (EQL D E)->(EQL E D).
Axiom trans_EQL: (EQL D E)->(EQL E F)->(EQL D F).

(* Note: the user must give further axioms stating that		  *)
(* - for user-defined data-types D and E: ~(EQL D E);		  *)
(* - for user-defined constants  d and e: <bool>(eql D d e)=false.*)

End EQUALITY.

Axiom not_eql_true_false: <bool>(eql bool true false)=false.

Axiom data_eql:(D,E:Set)(p,q:D->E)(d,e:D)
<bool>(eql (D->E) p q)=true->
<bool>(eql D d e)=true->
<bool>(eql E (p d) (q e))=true.

Inductive Set one = i:one.

Axiom EQL0: ~(EQL one bool).

Hint refl_eql refl_EQL not_eql_true_false EQL0.
Immediate sym_eql sym_EQL.

Goal (b:bool)<bool>(eql bool b (neg b))=false.
Induction b.
	Auto.
Elim sym_eql;Auto.
Save not_eql_b_negb.

Goal (D,E:Set)(p,q:D->E)(d,e:D)
<bool>(eql (D->E) p q)=true->
<bool>(eql E (p d) (q e))=false->
<bool>(eql D d e)=false.
Intros.
Elim (EM_bool (eql D d e));Intro.
	Rewrite H1.	
	Elim H0.
	Rewrite (data_eql D E p q);Auto.
Assumption.
Save data_not_eql.
Provide booleans.
