(* ======================================================================== *)
(*                          Actions                                         *)
(* ======================================================================== *)
(* The user provides an inductively defined set of actions, containing at   *)
(* least delta and tau. The user also defines the communication function    *)
(* gamma, with the following requirements:                                  *)
(* - communication is commutative                                           *)
(* - delta and tau do not communicate                                       *)
(* - actions obtained from communication do not communicate.                *)
(* ======================================================================== *)

Inductive Set act =
ain:act | aout:act | int:act | r:act | s:act | c:act | delta:act | tau:act.

Definition gamma = [e,f:act] (<act>Match e with
     delta
     delta
     delta
     (<act>Match f with delta delta delta delta c     delta delta delta)
     (<act>Match f with delta delta delta c     delta delta delta delta)
     delta
     delta
     delta).

(* Lemmas for proving automatically that a certain action is different from *)
(* tau or delta. These are mainly useful when CFAR is applied.              *)

Goal (a:act)(<Prop>Match a with True True True True True True True False)->
~(<act>tau=a).
Intros.
Red;Intro.
Change (<Prop>Match tau with True True True True True True True False).
Rewrite H0.
Assumption.
Save not_tau_action.

Goal (a:act)(<Prop>Match a with True True True True True True False True)->
~(<act>delta=a).
Intros.
Red;Intro.
Change (<Prop>Match delta with True True True True True True False True).
Rewrite H0.
Assumption.
Save not_delta_action.

Goal (a,b:act)~(<act>b=a)->~(<act>a=b).
Auto.
Save not_action_action.

Hint not_tau_action not_delta_action not_action_action.
Hint Unfold gamma.

(* Checking the properties of gamma; proofs are automatic (using case   *)
(* analysis, "induction", on actions where necessary).                  *)
(* These properties justify the axioms commDelta, commTau, SC3,         *)
(* and Handshaking, respectively.                                       *)

Goal (a:act)<act>(gamma delta a)=delta.
Auto.
Save gamma_delta_delta.

Goal (a:act)<act>(gamma tau a)=delta.
Auto.
Save gamma_tau_delta.

Goal (a,b:act)<act>(gamma a b)=(gamma b a).
Intros. Elim a; Auto; Elim b; Auto.
Save gamma_comm.

Goal (a,b,c:act)<act>(gamma a (gamma b c))=delta.
Intros. Elim a; Auto; Elim b; Elim c; Auto.
Save gamma_gamma_delta.

Provide actions.
