Require muCRL.

(* ============================================================= *)
(*			Specification				 *)
(* ============================================================= *)
Parameter D:Set. (* The data that is passed *)

Definition BufferEquation = [P:one->proc][i:one]
			    (sum D [d:D](seq (ia D ain  d)
			                  (seq (ia D aout d)
			                    (P i)           ))).
Parameter Buffer:proc.
Axiom BufferSpec: <proc>Buffer = (BufferEquation [i:one]Buffer i).

(* ============================================================= *)
(*			Data in the Implementation		 *)
(* ============================================================= *)
Parameter Frame,Frame_Err,bool_Err : Set.

Parameter pair       : D->bool->Frame.
Parameter data_of    :   Frame->D.
Parameter bit_of     :   Frame->bool.
Parameter iFrame     :   Frame->Frame_Err.
Parameter errorframe :          Frame_Err.
Parameter ibool      :   bool ->bool_Err.
Parameter errorbit   :          bool_Err.

Axiom pair_inj:(f:Frame)<bool>(eql Frame f (pair (data_of f) (bit_of f)))=true.
Axiom bit_inj :(b:bool)(d:D)<bool>(eql bool  b (bit_of (pair d b)))	 =true.
Axiom data_inj:(b:bool)(d:D)<bool>(eql D     d (data_of (pair d b)))	 =true.

Section INJECTIONS.
Variable b,c:bool.
Variable d,e:D.
Variable f,g:Frame.

Goal <bool>(eql D d e)=false \/ <bool>(eql bool b c)=false ->
	<bool>(eql Frame (pair d b) (pair e c))=false.
Intro H;Elim H;Intro.
	Apply (data_not_eql Frame D data_of data_of).
		Apply refl_eql.
	Rewrite (trans_eql D d (data_of (pair d b))).
		Rewrite (trans_eql D e (data_of (pair e c))).
			Assumption.
		Apply data_inj.
	Apply data_inj.
Apply (data_not_eql Frame bool  bit_of  bit_of).
	Apply refl_eql.
Rewrite (trans_eql bool b ( bit_of (pair d b))).
	Rewrite (trans_eql bool c ( bit_of (pair e c))).
		Assumption.
	Apply  bit_inj.
Apply  bit_inj.
Save differ_frame.

Goal <bool>(eql bool (bit_of f) (bit_of g))=true->
	<bool>(eql Frame f g)=(eql D (data_of f) (data_of g)).
Intro H.
Elim (EM_bool (eql Frame f g));Intro H0;Rewrite H0.
	Elim (data_eql Frame D data_of data_of f g);Auto.
Elim (data_not_eql D Frame [d:D](pair d (bit_of f)) [d:D](pair d (bit_of g))
			(data_of f) (data_of g));Auto.
	Apply (data_eql bool D->Frame [b:bool][d:D](pair d b)
			  [b:bool][d:D](pair d b) (bit_of f) (bit_of g));Auto.
Rewrite (trans_eql Frame f (pair (data_of f) (bit_of f))).
	Rewrite (trans_eql Frame g (pair (data_of g) (bit_of g))).
		Assumption.
	Apply pair_inj.
Apply pair_inj.
Save same_bool.

Axiom same_err_frame  : <bool>
			(eql Frame f g)=(eql Frame_Err (iFrame f) (iFrame g)).
Axiom find_errorframe : <bool>(eql Frame_Err (iFrame f) errorframe)=false.
Axiom same_err_bit    : <bool>(eql bool b c)=(eql bool_Err (ibool b) (ibool c)).
Axiom find_errorbit   : <bool>(eql bool_Err (ibool b) errorbit)=false.

End INJECTIONS.

Goal (f:Frame)(d:D)<bool>(eql Frame f (pair d (neg (bit_of f))))=false.
Intros.
Rewrite (trans_eql Frame (pair (data_of f) (bit_of f)) f).
	Apply differ_frame.
	Right.
	Elim sym_eql.
	Apply not_eql_b_negb.
Elim sym_eql.
Apply pair_inj.
Save nack.

Goal (f:Frame)(d:D)
<bool>(eql Frame f (pair d (bit_of f)))=(eql D (data_of f) d).
Intros.
Rewrite same_bool.
	Elim (trans_eql D (data_of (pair d (bit_of f))) d).
		Apply sym_eql.
	Elim sym_eql.
	Apply data_inj.
Apply bit_inj.
Save ack.

Axiom EQL1 : ~(EQL bool      D).
Axiom EQL2 : ~(EQL bool      Frame).
Axiom EQL3 : ~(EQL bool      Frame_Err).
Axiom EQL4 : ~(EQL bool      bool_Err).
Axiom EQL5 : ~(EQL one       D).
Axiom EQL6 : ~(EQL one       Frame).
Axiom EQL7 : ~(EQL one       Frame_Err).
Axiom EQL8 : ~(EQL one       bool_Err).
Axiom EQL9 : ~(EQL D         Frame).
Axiom EQL10: ~(EQL D         Frame_Err).
Axiom EQL11: ~(EQL D         bool_Err).
Axiom EQL12: ~(EQL Frame     Frame_Err).
Axiom EQL13: ~(EQL Frame     bool_Err).
Axiom EQL14: ~(EQL Frame_Err bool_Err).

Hint EQL1 EQL2 EQL3 EQL4 EQL5 EQL6 EQL7 EQL8 EQL9
     EQL10 EQL11 EQL12 EQL13 EQL14 sym_EQL.

Goal (A,B:Set)~(EQL A B)->~(EQL B A).
Red;Intros;Red in H;Auto.
Save sym_not_EQL.

Immediate sym_not_EQL.

(* ============================================================= *)
(*			Implementation				 *)
(* ============================================================= *)

(* the process-variables of the recursive equations *)
Inductive Set procvar =
Si 	:   bool->procvar |
Sid	: Frame ->procvar |
Tid	: Frame ->procvar |
Ri 	:   bool->procvar |
Ria	:   bool->procvar |
Rib	: Frame ->procvar |
K	:	  procvar |
Ka	: Frame ->procvar |
Kb	: Frame ->procvar |
Kc	:	  procvar |
L 	:	  procvar |
La	:   bool->procvar |
Lb	:   bool->procvar |
Lc	:	  procvar .

Parameter exp':procvar->proc.
(* Duplication of exp and exp' is used to obtain recursion *)
(* and in addition to control term-rewriting *)
(* the recursive equations: *)
Definition exp = [a:procvar](<proc>Match a with
 [b:bool](sum D [d:D](seq (ia D ain d)		  (exp' (Sid (pair d b)))))
[f:Frame]            (seq (ia Frame s f)	  (exp' (Tid f)))
[f:Frame](alt (seq (alt (ia bool_Err r (ibool (neg (bit_of f))))
			(ia bool_Err r errorbit))     
						  (exp' (Sid f)))
	      (seq      (ia bool_Err r (ibool (bit_of f)))
						  (exp' (Si (neg (bit_of f))))))
 [b:bool](alt (seq (alt (sum D [d:D](ia Frame_Err r (iFrame (pair d b))))
				    (ia Frame_Err r errorframe))
						  (exp' (Ria b)))
	      (sum D [d:D](seq (ia Frame_Err r (iFrame (pair d (neg b))))
						  (exp' (Rib (pair d b))))))
 [b:bool](seq (ia bool s (b))			  (exp' (Ri b)) )
[f:Frame](seq (ia D aout (data_of f))		  (exp' (Ria (neg (bit_of f)))))
	 (sum Frame [f:Frame] (seq (ia Frame r f) (exp' (Ka f))))
[f:Frame](alt (seq (ia one int i)		  (exp' (Kb f)))
	      (seq (ia one int i)		  (exp' Kc)))
[f:Frame](seq (ia Frame_Err s (iFrame f))	  (exp' K))
	 (seq (ia Frame_Err s errorframe)	  (exp' K))
	 (sum bool [b:bool](seq (ia bool r b)	  (exp' (La b))))
 [b:bool](alt (seq (ia one int i)		  (exp' (Lb b)))
	      (seq (ia one int i)		  (exp' Lc)))
 [b:bool](seq (ia bool_Err s (ibool b))		  (exp' L ))
	 (seq (ia bool_Err s errorbit)		  (exp' L ))).

Axiom expand: <procvar->proc>exp'=exp.

Definition H:ehset= [a:act](<Prop>Match a with
		False False False True True False False False).
Definition I':ehset= [a:act](<Prop>Match a with
		False False True False False True False False).

Definition ABP = (hide I' (enc H 
		       (mer (exp (Si true ))
		       (mer (exp (Ri false))
		       (mer (exp K	)
		            (exp L	) ))) )).

Goal (a:act)(H a)->(goodset H a).
Induction a;Unfold goodset;Unfold H;Auto.
Save goodset_H.

Goal (a:act)(I' a)->(goodset I' a).
Induction a;Unfold goodset;Unfold I';Auto.
Save goodset_I'.

Hint goodset_H goodset_I'.
Hint Unfold H I'.

(* ========================================================= *)
(*                Failing communications.                    *)
(* ========================================================= *)

(* for the pairs where the following function is True, *)
(* we prove that they do not communicate. *)

Definition nocommpair = [a,a':procvar]
(<Prop>Match a with
[b:bool] False
[f:Frame] False
[f:Frame] (<Prop>Match a' with
	[b:bool]False	  [f:Frame]False     [f:Frame]False
	[b:bool]True  	   [b:bool]True      [f:Frame]True 
	True		  [f:Frame]True      [f:Frame]True  True 
	True  		   [b:bool]True       [b:bool]False False)
[b:bool] (<Prop>Match a' with
	[b:bool]True	  [f:Frame]True      [f:Frame]False
	[b:bool]False 	   [b:bool]False     [f:Frame]False
	True		  [f:Frame]True      [f:Frame]False False
	True  		   [b:bool]True       [b:bool]True  True )
[b:bool] False
[f:Frame] False
(<Prop>Match a' with
	[b:bool]True	  [f:Frame]False     [f:Frame]False
	[b:bool]False 	   [b:bool]True      [f:Frame]True 
	False		  [f:Frame]False     [f:Frame]False False
	True  		   [b:bool]True       [b:bool]True  True )
[f:Frame] False
[f:Frame] False
False
(<Prop>Match a' with
	[b:bool]True	  [f:Frame]True      [f:Frame]False
	[b:bool]False 	   [b:bool]False     [f:Frame]True 
	False		  [f:Frame]True      [f:Frame]True  True 
	False 		   [b:bool]False      [b:bool]False False)
[b:bool] False
[b:bool] False
False).

Hint Unfold nocommpair.

Goal (a,a':procvar) (nocommpair a a') ->
                             <proc>Delta=(comm (exp a) (exp a')).
Induction a;Induction a';Intros;
Contradiction (* check if nocommpair case *) Orelse
Unfold exp;
Repeat Elim A4;
Repeat Elim CM8;
Repeat Elim CM9;
Do 4 (Try Apply RuleA6);
Try Elim SUM5;
Do 2 (Try ((Elim SUM7 Orelse Elim SUM7');Apply RuleSUM1;Intro));
Elim CM7;
Apply RuleA7;
(Apply CF1;Unfold gamma;Elim Delta_Data;Elim COND3) Orelse (Apply CF2;Auto).
Save nocom.

Goal (a,a':procvar) ((nocommpair a a')\/(nocommpair a' a)) ->
			     <proc>Delta = (comm (exp a) (exp a')).
Intros.
Elim H;Intros.
	Apply nocom;Assumption.
Elim SC3;Apply nocom;Assumption.
Save nocom'.

(* ======================================================= *)
(*		Intermediate States and CFAR		   *)
(* ======================================================= *)

Definition X  = [b:bool](enc H 
		       (mer (exp (Si b	    ))
		       (mer (exp (Ri (neg b)))
		       (mer (exp K	     )
		            (exp L 	     ) ))) ).

Definition X1 = [f:Frame](enc H 
		       (mer (exp (Sid f		     ))
		       (mer (exp (Ri (neg (bit_of f))))
		       (mer (exp K		      )
		            (exp L 		      ) ))) ).

Definition X2 = [f:Frame](enc H 
		       (mer (exp (Tid f         ))
		       (mer (exp (Ria (bit_of f)))
		       (mer (exp K	        )
		            (exp L 	        ) ))) ).

Inductive Set Nr
= n1n:Nr | n2n:Nr | n3n:Nr | n4n:Nr | n5n:Nr | n6n:Nr | n7n:Nr.

Axiom samenumbers:(n,n':Nr)<bool>(eql Nr n n')=true-><Nr>n=n'.

Definition diff=[n:Nr](<Nr->Prop>Match n with
[m:Nr](<Prop>Match m with False True  True  True  True  True  True )
[m:Nr](<Prop>Match m with True  False True  True  True  True  True )
[m:Nr](<Prop>Match m with True  True  False True  True  True  True )
[m:Nr](<Prop>Match m with True  True  True  False True  True  True )
[m:Nr](<Prop>Match m with True  True  True  True  False True  True )
[m:Nr](<Prop>Match m with True  True  True  True  True  False True )
[m:Nr](<Prop>Match m with True  True  True  True  True  True  False)).

Goal (n,n':Nr)(diff n n')-><bool>(eql Nr n n')=false.
Intros.
Elim (EM_bool (eql Nr n n'));Intro.
	Absurd <Nr>n=n'.
		Red;Intro.
		Generalize H.
		Elim H1.
		Unfold diff;Elim n;Auto.
	Apply samenumbers;Assumption.
Assumption.
Save diff_Nr.

Goal (p:Nr->proc)<proc>(alt (p n1n) (alt (p n2n) (alt (p n3n) (alt (p n4n)
			(alt (p n5n) (alt (p n6n) (p n7n) ))))))=(sum Nr p).
Intro.
Rewrite (SUMmand Nr n1n).
Rewrite (SUMmand Nr n2n).
Rewrite (SUMmand Nr n3n).
Rewrite (SUMmand Nr n4n).
Rewrite (SUMmand Nr n5n).
Rewrite (SUMmand Nr n6n).
(Elim (RuleSUMrep Nr n7n (p n7n));
 [Idtac|Induction d;Rewrite refl_eql;Elim COND1]);
Repeat (Rewrite diff_Nr;[Elim COND2|Unfold diff;Exact I]);
Apply refl_equal.
Save EXP_Nr_SUM.

(* ======================================================= *)
(*			Steps 				   *)
(* ======================================================= *)

Goal (b:bool)<proc>(sum D [d:D](seq (ia D ain d) (hide I' (X1 (pair d b)))))=
		   (hide I' (X b)).
Intro.
Unfold X;Elim EXP4.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Unfold X1.
Elim (proc_equal_if_data_eql bool [b:bool](exp (Ri (neg b))) b
				   		      (bit_of (pair d b)) ).
	Apply refl_equal.
Apply bit_inj.
Save Step_X_X1.

Section STEPS1.
Variable b:bool.
Variable d:D.
Variable f:Frame.

Definition Out1 =
	(seq (ia one int i)
	(seq (ia Frame_Err c (iFrame f))
	(seq (ia D aout (data_of f)) (X2 f)))).

Definition X1_7 = (seq (ia bool_Err c errorbit) (X1 f)).
Definition X1_6 = (seq (ia bool_Err c (ibool (neg (bit_of f)))) (X1 f)).
Definition X1_5 = (alt (seq (ia one int i) X1_6)
		       (seq (ia one int i) X1_7)).
Definition X1_4 = (seq (ia bool c (neg (bit_of f))) X1_5).
Definition X1_3 = (seq (ia Frame_Err c errorframe) X1_4).
Definition X1_2 = (alt Out1
		       (seq (ia one int i) X1_3)).

Goal <proc>(seq (ia Frame c f) X1_2)=(X1 f).
Unfold X1.
Elim EXP4.
Unfold 33 34 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Rewrite (proc_equal_if_data_eql Frame [d:Frame](exp (Ka d)) d f);
[Idtac|Elim sym_eql;Assumption].
Clear H0 d.
Unfold X1_2.
Unfold Out1.
Unfold X1_3.
Unfold X1_4.
Unfold X1_5.
Unfold X1_6.
Unfold X1_7.
Elim EXP4.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Elim EXP4.
	Unfold 33 34 exp.
	Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Rewrite (proc_equal_if_data_eql D [d:D](exp (Rib (pair d (neg (bit_of f)))))
			d (data_of f));[Idtac|Elim sym_eql;Assumption].
	Clear H0 d.
	Elim SC7.
	Elim EXP4.
	Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Elim (proc_equal_if_data_eql D [d:D](ia D aout d)
		(data_of f) (data_of (pair (data_of f) (neg (bit_of f)))));
		Try Apply data_inj.
	Elim (proc_equal_if_data_eql bool [b:bool](exp (Ria b))
		(bit_of f) (neg (bit_of (pair (data_of f) (neg (bit_of f)))))).
		Do 2 Rewrite SC7.
		Elim (SC6 (exp (Tid f))).
		Do 2 Elim SC7.
		Apply refl_equal.
	Elim (trans_eql bool 
		(neg (bit_of (pair (data_of f) (neg (bit_of f)))))
		(neg (neg (bit_of f)))).
	Rewrite negs;Apply refl_eql.
	Apply (data_eql bool bool neg neg).
		Apply refl_eql.
	Elim sym_eql;Apply bit_inj.
Elim EXP4.
Unfold 33 34 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Elim EXP4.
Unfold 25 26 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Elim EXP4.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Elim EXP4.
	Unfold 37 38 exp.
	Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Do 2 (Rewrite (SC6 (exp L)); Elim SC7).
	Apply refl_equal.
Elim EXP4.
Unfold 37 38 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Do 2 (Rewrite (SC6 (exp L)); Elim SC7).
Apply refl_equal.
Save Step_X1_X2.

Definition X1n = [n:Nr](<proc>Match n with
(X1 f) X1_2 X1_3 X1_4 X1_5 X1_6 X1_7).

Definition Out = [n:Nr](<proc>Match n with
Delta Out1 Delta Delta Delta Delta Delta).

Definition Int = [n:Nr](<Nr->proc>Match n with
[m:Nr](<proc>Match m with Delta (ia Frame c f) Delta Delta Delta Delta Delta)
[m:Nr](<proc>Match m with Delta Delta (ia one int i) Delta Delta Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta (ia Frame_Err c errorframe) Delta
				Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta Delta (ia bool c (neg (bit_of f)))
				Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta Delta Delta
				(ia one int i) (ia one int i))
[m:Nr](<proc>Match m with (ia bool_Err c (ibool (neg (bit_of f)))) Delta Delta
				Delta Delta Delta Delta)
[m:Nr](<proc>Match m with (ia bool_Err c errorbit) Delta Delta Delta Delta
				Delta Delta)).

Definition inn = [n,n':Nr](act_of (Int n n')).

Goal (n:Nr)(Reach I' Nr inn n1n n).
Induction n;
Try Apply (reacht I' Nr inn n6n n1n n1n);
Try Apply (reacht I' Nr inn n5n n1n n7n);
Try Apply (reacht I' Nr inn n5n n1n n6n);
Try Apply (reacht I' Nr inn n4n n1n n5n);
Try Apply (reacht I' Nr inn n3n n1n n4n);
Try Apply (reacht I' Nr inn n2n n1n n3n);
Apply reach1;
Unfold inn;
Unfold Int;
Rewrite act_of_act;
Exact I.
Save Reach_1_n.

Goal (n:Nr)(Reach I' Nr inn n n1n).
Induction n;
Try Apply Reach_1_n;
Try Apply (reacht I' Nr inn n3n n2n n1n);
Try Apply (reacht I' Nr inn n4n n3n n1n);
Try Apply (reacht I' Nr inn n5n n4n n1n);
Try Apply (reacht I' Nr inn n6n n5n n1n);
Apply reach1;
Unfold inn;
Unfold Int;
Rewrite act_of_act;
Exact I.
Save Reach_n_1.

Goal (n,n':Nr)(Reach I' Nr inn n n').
Intros.
Apply (reacht I' Nr inn n1n n n');
[Apply Reach_n_1|Apply Reach_1_n].
Save connected.

Goal <proc>(seq Tau (hide I' (X1n n1n)))=
	   (seq Tau (sum Nr [n0:Nr](hide I' (Out n0)))).
Apply (CFARmin I' Nr X1n Out Int inn).
(* 1 *) Induction n;Induction n';Unfold inn;Unfold Int;Unfold Delta;
	Rewrite act_of_act;Auto.
(* 2 *) Exact connected.
(* 3 *) Induction n;Induction n';Unfold inn;Unfold Int;Unfold Delta;
	Rewrite act_of_act;Apply not_tau_action;Exact I.
(* 4 *) Unfold inn;Auto.
(* 5 *) Unfold X1n Int Out.
	Induction n;Elim EXP_Nr_SUM;
	Repeat Elim A7;Repeat Elim A6;Repeat Elim A6';
	Apply refl_equal Orelse 
	(Elim A1;Apply refl_equal) Orelse
	(Elim Step_X1_X2;Apply refl_equal).
Save Hiddenstep1.

End STEPS1.

Goal  (b:bool)<proc>(sum D [d:D](seq (ia D ain d) 
				(seq (ia D aout d)
				     (hide I' (X2 (pair d b)))))) =
		    (hide I' (X b)).
Intro.
Elim Step_X_X1.
Apply SUM11;Intro.
Replace (ia D ain d) with (seq (ia D ain d) Tau).
	Repeat Elim A5.
	Apply (f_equal proc proc (seq (ia D ain d))).
	Replace (X1 (pair d b)) with (X1n (pair d b) n1n).
		Rewrite Hiddenstep1.
		Elim EXP_Nr_SUM.
		Unfold Out.
		Repeat Elim TI1_Delta.
		Repeat Elim A6'.
		Repeat Elim A6.
		Unfold Out1.
		Repeat Elim TI4.
		Do 2 (Elim TI2;[Idtac|Auto]).
		Repeat (Rewrite A5;Elim TAU1).
		Elim TI1;[Idtac|Auto].
		Elim (proc_equal_if_data_eql D (ia D aout) d (data_of (pair d b))).
			Apply refl_equal.
		Apply data_inj.
	Apply refl_equal.
Apply sym_equal;Apply TAU1.
Save Steps_X_X2.

Section STEPS2.
Variable b:bool.
Variable d:D.
Variable f:Frame.

Definition Out2 =
	(seq (ia one int i)
	(seq (ia bool_Err c (ibool (bit_of f))) (X (neg (bit_of f))))).

Definition X2_7 = (seq (ia Frame_Err c errorframe) (X2 f)).
Definition X2_6 = (seq (ia Frame_Err c (iFrame f)) (X2 f)).
Definition X2_5 = (alt (seq (ia one int i) X2_6)
		       (seq (ia one int i) X2_7)).
Definition X2_4 = (seq (ia Frame c f) X2_5).
Definition X2_3 = (seq (ia bool_Err c errorbit) X2_4).
Definition X2_2 = (alt Out2
		       (seq (ia one int i) X2_3)).

Goal <proc> (seq (ia bool c (bit_of f)) X2_2)=(X2 f).
Unfold X2.
Elim EXP4.
Unfold 25 26 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Unfold X2_2.
Unfold Out2.
Unfold X2_3.
Unfold X2_4.
Unfold X2_5.
Unfold X2_6.
Unfold X2_7.
Elim EXP4.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Elim EXP4.
	Unfold 33 34 exp.
	Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Do 2 (Rewrite (SC6 (exp L));Elim SC7).
	Unfold X.
	Rewrite negs.
	Apply refl_equal.
Elim EXP4.
Unfold 33 34 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Elim EXP4.
Unfold 25 26 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Elim SC7.
Elim EXP4.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Rewrite (proc_equal_if_data_eql Frame [d:Frame](exp (Kb d)) d f);
	[Idtac|Elim sym_eql;Assumption].
	Clear H0 d.
	Elim EXP4.
	Unfold 37 38 exp.
	Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
	Rewrite (SC6 (exp K)).
	Rewrite SC7.
	Elim (SC6 (exp (Tid f))).
	Repeat Elim SC7.
	Apply refl_equal.
Elim EXP4.
Unfold 37 38 exp.
Load "$COQTH/CONTRIB/Eindhoven/ABP/step".
Rewrite (SC6 (exp K)).
Rewrite SC7.
Elim (SC6 (exp (Tid f))).
Repeat Elim SC7.
Apply refl_equal.
Save Step_X2_X.

Definition X2n = [n:Nr](<proc>Match n with
(X2 f) X2_2 X2_3 X2_4 X2_5 X2_6 X2_7).

Definition Out = [n:Nr](<proc>Match n with
Delta Out2 Delta Delta Delta Delta Delta).

Definition Int = [n:Nr](<Nr->proc>Match n with
[m:Nr](<proc>Match m with Delta (ia bool c (bit_of f)) Delta Delta Delta
				Delta Delta)
[m:Nr](<proc>Match m with Delta Delta (ia one int i) Delta Delta Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta (ia bool_Err c errorbit) Delta
				Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta Delta (ia Frame c f) Delta Delta)
[m:Nr](<proc>Match m with Delta Delta Delta Delta Delta
				(ia one int i) (ia one int i))
[m:Nr](<proc>Match m with (ia Frame_Err c (iFrame f)) Delta Delta
				Delta Delta Delta Delta)
[m:Nr](<proc>Match m with (ia Frame_Err c errorframe) Delta Delta Delta Delta
				Delta Delta)).

Goal (n,n':Nr)<act>(inn f n n')=(act_of (Int n n')).
Unfold inn.
Unfold Int.
Unfold Delta.
Induction n;Induction n';Repeat Rewrite act_of_act;Apply refl_equal.
Save inn_Int.

Goal <proc>(seq Tau (hide I' (X2n n1n)))=
	   (seq Tau (sum Nr [n0:Nr](hide I' (Out n0)))).
Apply (CFARmin I' Nr X2n Out Int (inn f)).
(* 1 *) Intros.
	Rewrite inn_Int.
	Elim n;Elim n';Unfold Int;Unfold Delta;
	Rewrite act_of_act;Auto.
(* 2 *) Exact (connected f).
(* 3 *) Intros.
	Rewrite inn_Int.
	Elim n;Elim n';Unfold Int;Unfold Delta;
	Rewrite act_of_act;Apply not_tau_action;Exact I.
(* 4 *) Exact inn_Int.
(* 5 *) Unfold X2n Int Out.
	Induction n;Elim EXP_Nr_SUM;
	Repeat Elim A7;Repeat Elim A6;Repeat Elim A6';
	Apply refl_equal Orelse 
	(Elim A1;Apply refl_equal) Orelse
	(Elim Step_X2_X;Apply refl_equal).
Save Hiddenstep2.

End STEPS2.

Goal (f:Frame)<proc>(seq Tau (hide I' (X (neg (bit_of f)))))=
		    (seq Tau (hide I' (X2 f))).
Intro.
Replace (X2 f) with (X2n f n1n).
	Rewrite Hiddenstep2.
	Elim EXP_Nr_SUM.
        Unfold Out.
        Repeat Elim TI1_Delta.
        Repeat Elim A6'.
        Repeat Elim A6.
        Unfold Out2.
        Repeat Elim TI4.
	Repeat (Elim TI2;[Idtac|Auto]).
	Repeat (Rewrite A5;Elim TAU1).
	Apply refl_equal.
Apply refl_equal.
Save Steps_X2_X.

Goal (b:bool)<proc>(sum D [d:D] (seq (ia D ain d)
	                        (seq (ia D aout d)
				     (hide I' (X (neg b))))))=(hide I' (X b)).
Intro.
Elim Steps_X_X2.
Apply SUM11;Intro.
Replace (ia D aout d) with (seq (ia D aout d) Tau).
	Repeat Elim A5.
	Elim Steps_X2_X.
	Rewrite (proc_equal_if_data_eql bool [b:bool](X (neg b)) b
						  	  (bit_of (pair d b))).
		Apply refl_equal.
	Apply bit_inj.
Elim TAU1;Apply refl_equal.
Save Steps_X_X.

Hint Steps_X_X.

Goal (b:bool)<proc>(hide I' (X b))=(hide I' (X (neg b))).
Intro.
Apply (RSP bool [b:bool](hide I' (X b))
		[b:bool](hide I' (X (neg b)))
   [p:bool->proc][b:bool](sum D [d:D] (seq (ia D ain d)
                               	      (seq (ia D aout d) (p (neg b))))) );
Auto 10.
Save Same_X_Xneg.

Goal <proc>Buffer=ABP.
Apply (RSP one [i:one]Buffer [i:one]ABP BufferEquation).
			Unfold BufferEquation;Auto 10.
		Induction d;Apply BufferSpec.
	Replace ABP with (hide I' (X true)).
		Pattern 2 X.
		Elim Steps_X_X.
		Elim Same_X_Xneg.
		Intro;Apply refl_equal.
	Apply refl_equal.
Instantiate i.
Save Correct.

Provide ABP.
