(*
Author: Pierre Casteran.
    LABRI, URA CNRS 1304,
    Departement d'Informatique, Universite Bordeaux I, 
    33405 Talence CEDEX,
    e-mail:  casteran@labri.u-bordeaux.fr

Date: May, 3, 1993

Pro[gramm,v]ing with continuations:A development in Coq.

(see the file "leavemult.dvi" for more explanations )

*)


(* Binary trees on some domain:
*)

Section Domain.

Variable Dom:Set.

Inductive Set tree = leaf : Dom -> tree
                   | cons : tree -> tree -> tree.
End Domain.



(* Binary trees labeled by natural numbers
*)


Definition nat_tree = (tree nat).
Definition nat_cons = (cons nat).
Definition nat_leaf =(leaf nat).


(* Product of all the leaves of some nat_tree 
*)


Definition leavemult: nat_tree -> nat =
   [t:nat_tree](<nat> Match t with
     (* (nat_leaf n1) *)
          ([n1:nat] n1)
     (* (nat_cons t1 t2) *)
          ([t1:nat_tree][s1:nat][t2:nat_tree][s2:nat](mult  s1 s2))).


(* the specification  of our problem:
*)

Definition SPECIF=[t:nat_tree] {n:nat|(<nat>n=(leavemult t))}.




(* A (too much) trivial proof 
*)

Theorem trivialalgo: (t:nat_tree)(SPECIF t).
Goal.Intro t.Unfold SPECIF. Apply exist with (leavemult t);Auto.
Save.


(* Here we  define a predicate "Has an occurrence of O" 
*)


Definition Has_Zero : nat_tree -> Prop
  = [t:nat_tree](<Prop> Match t with
                     (* (nat_leaf n1) *)
                         ([n1: nat] <nat>n1 = O)
                     (* (nat_cons t1 t2) *)
                         ([t1: nat_tree][h1:Prop][t2:nat_tree][h2:Prop]
                                 (h1 \/ h2))).




(* If some tree t has an occurence of 0, then (leavmult t)=0 
*)

Lemma zero_occ: (t:nat_tree)(Has_Zero t)-><nat>(leavemult t)=O.
Goal.
Induction t.Induction d;Simpl;Auto.Intros t1 H1 t2 H2 H.
Simpl.Elim H;Intro H0.
Cut <nat>(leavemult t1)=O.Intro H3.Rewrite H3;Simpl;Auto.Auto.
Cut <nat>(leavemult t2)=O.Intro H3.Rewrite H3;Simpl.
Symmetry;Apply mult_n_O.Auto.
Save.







(* A  proof of (t:nat_tree)(SPECIF t)
   which uses the preceding lemma
*)


Theorem cpsalgo: (t:nat_tree)(SPECIF t).
Goal.
Intro.
Cut (Has_Zero t) -> (SPECIF t).
Intro ESCAPE_O.

(*
2 subgoals
  (SPECIF t)
  ============================
    ESCAPE_O : (Has_Zero t)->(SPECIF t)
    t : nat_tree
subgoal 2 is:
  (Has_Zero t)->(SPECIF t)
*)



2:Intro.
2:Unfold SPECIF.
2:Apply exist with O.
2:Symmetry.
2:Apply zero_occ.
2:Auto.

(*
1 subgoal
  (SPECIF t)
  ============================
    ESCAPE_O : (Has_Zero t)->(SPECIF t)
    t : nat_tree

*)
Local subtree_ersatz=[t',t:nat_tree]((Has_Zero t')->(Has_Zero t)).

Hint Unfold subtree_ersatz.

Local kappa=[t:nat_tree]
                   [t':nat_tree]
                       (n':nat)(<nat>n'=(leavemult t'))-> (SPECIF t).
Hint Unfold kappa.

Cut (t':nat_tree)(subtree_ersatz t' t)->(kappa t t')->(SPECIF t).
Hint Unfold SPECIF.

Intro AUX.
Apply AUX with t.
Auto.
Unfold kappa.
Intros n H.
Unfold SPECIF;Apply exist with n;Auto.

(*
1 subgoal
  (t':nat_tree)(subtree_ersatz t' t)->(kappa t t')->(SPECIF t)
  ============================
    ESCAPE_O : (Has_Zero t)->(SPECIF t)
    t : nat_tree

*)

Induction t'.
Induction d.
Intros H H0.
Apply ESCAPE_O.
Apply H.Simpl.
Auto.
Intros y H1 H2 H3.
Unfold kappa in H3.
Apply H3 with (S y).
Simpl.
Auto.

Intro t1. Intro ind1. Intro t2. Intro ind2.Intros H H0.
Apply ind2.
Unfold subtree_ersatz.
Intro H1.
Unfold subtree_ersatz in H;Apply H.
Unfold Has_Zero.
Unfold Has_Zero in H1.Auto.
(*

1 subgoal
  (kappa t t2)
  ============================
    H0 : (kappa t (cons nat t1 t2))
    H : (subtree_ersatz (cons nat t1 t2) t)
    ind2 : (subtree_ersatz t2 t)->(kappa t t2)->(SPECIF t)
    t2 : (tree nat)
    ind1 : (subtree_ersatz t1 t)->(kappa t t1)->(SPECIF t)
    t1 : (tree nat)
    t' : nat_tree
    ESCAPE_O : (Has_Zero t)->(SPECIF t)
    t : nat_tree



*)



Unfold kappa.
Unfold kappa in H0.
Intros n2 eg2.

(*

1 subgoal
  (SPECIF t)
  ============================
    eg2 : <nat>n2=(leavemult t2)
    n2 : nat
    H0 : (n':nat)(<nat>n'=(leavemult (cons nat t1 t2)))->(SPECIF t)
    H : (subtree_ersatz (cons nat t1 t2) t)
    ind2 : (subtree_ersatz t2 t)->(kappa t t2)->(SPECIF t)
    t2 : (tree nat)
    ind1 : (subtree_ersatz t1 t)->(kappa t t1)->(SPECIF t)
    t1 : (tree nat)
    t' : nat_tree
    ESCAPE_O : (Has_Zero t)->(SPECIF t)
    t : nat_tree


*)



Apply ind1.
Unfold subtree_ersatz.
Intro.
Apply H.
Simpl;Auto.
Unfold kappa.
Intros n1 eg1.
Apply H0 with (mult n1 n2).
Simpl.
Rewrite eg2;Rewrite eg1.
Auto.

Save.


(*
Coq < Extraction cpsalgo.

cpsalgo ==> [t:nat_tree]
             (tree_rec nat (nat->SPECIF)->SPECIF
                [d:nat]
                 (nat_rec (nat->SPECIF)->SPECIF [H0:nat->SPECIF](exist nat O)
                    [d1:nat]
                     [H1:(nat->SPECIF)->SPECIF][H3:nat->SPECIF](H3 (S d1))
                    d)
                [t1:(tree nat)]
                 [ind1:(nat->SPECIF)->SPECIF]
                  [t2:(tree nat)]
                   [ind2:(nat->SPECIF)->SPECIF]
                    [H0:nat->SPECIF]
                     (ind2 [n2:nat](ind1 [n1:nat](H0 (mult n1 n2))))
                t [n:nat](exist nat n))


Coq < Extraction SPECIF.
SPECIF ==> (sig nat)

Coq < Extraction kappa.
kappa ==> nat->SPECIF
*)

