(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                        Lemmas on boolean values                           *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                         Gerard Huet - May 1991                            *)
(* 	           C. Paulin - B. Werner - April 1992			     *)
(* 	                 						     *)
(*****************************************************************************)

(************)
(* Booleans *)
(************)

(* Inductive Set bool = true : bool | false : bool (from Prelude) *)

Definition Is_true = [b:bool](<Prop>Match b with
    (* true  *)  True
    (* false *)  False).

Lemma diff_true_false : ~<bool>true=false.
Goal.
Unfold not; Intro contr; Change (Is_true false).
Elim contr; Simpl; Trivial.
Save.


(************)
(* Negation *)
(************)

Definition neg = [b:bool](<bool>Match b with
    (* true *)  false
    (* false*)  true).

Lemma neg_intro : (b:bool)<bool>(neg (neg b))=b.
Goal.
Induction b; Simpl; Auto.
Save.

Lemma neg_elim : (b:bool)<bool>b=(neg (neg b)).
Goal.
Induction b; Simpl; Trivial.
Save.
       
Lemma neg_sym : (b,b':bool)(<bool>b'=(neg b))->(<bool>b=(neg b')).
Goal.
Induction b; Induction b'; Intros; Simpl; Trivial.
Save.

Lemma no_fixpoint_neg : (b:bool)~<bool>(neg b)=b.
Goal.
Induction b; Simpl; Unfold not; Intro; Apply diff_true_false; Auto.
Save.

(* Logical boolean functions *)
 
Definition ifb : bool -> bool -> bool -> bool
     = [b1,b2,b3:bool](<bool>Match b1 with (* true *) b2
                                          (* false *) b3).

Definition negb : bool -> bool
     = [b:bool](ifb b false true).

Definition andb : bool -> bool -> bool
     = [b1,b2:bool](ifb b1 b2 false).

Definition orb : bool -> bool -> bool
     = [b1,b2:bool](ifb b1 true b2).

Definition implb : bool -> bool -> bool
     = [b1,b2:bool](ifb b1 b2 true).


Provide Bool.
