(* Well-founded relations and natural numbers *)

Require Lt.

Chapter  Well_founded.

Variable A : Set.

Variable f : A -> nat.
Definition ltof = [a,b:A](lt (f a) (f b)).
Definition gtof = [a,b:A](gt (f b) (f a)).

Theorem well_founded_ltof : (well_founded A ltof).
Goal.
Red.
Cut (n:nat)(a:A)(lt (f a) n)->(Acc A ltof a).
Intros H a;  Apply (H (S (f a))); Auto.
Induction n.
Intros; Absurd (lt (f a) O); Auto.
Intros m Hm a ltSma.
Apply Acc_intro.
Unfold ltof; Intros b ltfafb.
Apply Hm.
Apply lt_le_trans with (f a); Auto.
Save.

Theorem  well_founded_gtof : (well_founded A gtof).
Proof well_founded_ltof.

(* It is possible to directly prove the induction principle going
   back to primitive recursion on natural numbers (induction_ltof1)
   or to use the previous lemmas to extract a program with a fixpoint
   (induction_ltof2) 
the ML-like program for induction_ltof1 is :
   let induction_ltof1 F a = indrec ((f a)+1) a 
   where rec indrec = 
        function 0    -> (function a -> error)
               |(S m) -> (function a -> (F a (function y -> indrec y m)));;
the ML-like program for induction_ltof2 is :
   let induction_ltof2 F a = indrec a
   where rec indrec a = F a indrec;;
*)

Theorem induction_ltof1 : (P:A->Set)((x:A)((y:A)(ltof y x)->(P y))->(P x))->(a:A)(P a).
Goal.
Intros P F; Cut (n:nat)(a:A)(lt (f a) n)->(P a).
Intros H a;  Apply (H (S (f a))); Auto.
Induction n.
Intros; Absurd (lt (f a) O); Auto.
Intros m Hm a ltSma.
Apply F.
Unfold ltof; Intros b ltfafb.
Apply Hm.
Apply lt_le_trans with (f a); Auto.
Save. 

Theorem induction_gtof1 : (P:A->Set)((x:A)((y:A)(ltof y x)->(P y))->(P x))->(a:A)(P a).
Proof induction_ltof1.

Theorem induction_ltof2 
   : (P:A->Set)((x:A)((y:A)(ltof y x)->(P y))->(P x))->(a:A)(P a).
Proof (well_founded_induction A ltof well_founded_ltof).

Theorem induction_gtof2 : (P:A->Set)((x:A)((y:A)(gtof y x)->(P y))->(P x))->(a:A)(P a).
Proof induction_ltof2.

End Well_founded.

Lemma lt_wf : (well_founded nat lt).
Proof (well_founded_ltof nat [m:nat]m).

Lemma lt_wf_ind : (p:nat)(P:nat->Set)
              ((n:nat)((m:nat)(lt m n)->(P m))->(P n)) -> (P p).
Proof [p:nat][P:nat->Set][F:(n:nat)((m:nat)(lt m n)->(P m))->(P n)]
     (induction_ltof1 nat [m:nat]m P F p).

Lemma gt_wf_ind : (p:nat)(P:nat->Set)
              ((n:nat)((m:nat)(gt n m)->(P m))->(P n)) -> (P p).
Proof lt_wf_ind.


Provide Wf_nat.
