(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      Arithmetic                                                           *)
(*                                                                           *)
(*      Addition                                                             *)
(*                                                                           *)
(*****************************************************************************)

Require Peano.

(************************************************************************)
(*  Properties of addition                                              *)
(************************************************************************)

Lemma plus_sym : (n,m:nat)<nat>(plus n m)=(plus m n).
Goal.
Intros n m ; Elim n ; Simpl ; Auto.
Intros y H ; Elim (plus_n_Sm m y) ; Auto.
Save.
Immediate plus_sym.

Lemma simpl_plus_l : (n,m,p:nat)(<nat>(plus n m)=(plus n p))-><nat>m=p.
Goal.
Induction n ; Simpl ; Auto.
Save.

Lemma plus_assoc_l : (n,m,p:nat)<nat>(plus n (plus m p))=(plus (plus n m) p).
Goal.
Intros n m p; Elim n; Simpl; Auto.
Save.
Hint plus_assoc_l.

Lemma plus_permute : (n,m,p:nat) <nat>(plus n (plus m p))=(plus m (plus n p)).
Goal. 
Intros; Rewrite plus_assoc_l; Rewrite (plus_sym m n); Auto.
Save.

Lemma plus_assoc_r : (n,m,p:nat)<nat>(plus (plus n m) p)=(plus n (plus m p)).
Goal.
Auto.
Save.
Hint plus_assoc_r.

Require Le.

Lemma simpl_le_plus_l : (p,n,m:nat)(le (plus p n) (plus p m))->(le n m).
Goal.
Induction p; Simpl; Auto.
Save.

Lemma le_reg_l : (n,m,p:nat)(le n m)->(le (plus p n) (plus p m)).
Goal.
Induction p; Simpl; Auto.
Save.
Hint le_reg_l.

Lemma le_reg_r : (a,b,c:nat) (le a b)->(le (plus a c) (plus b c)).
Goal.
Induction 1 ; Simpl; Auto.
Save.
Hint le_reg_r.

Lemma le_plus_plus : 
	(n,m,p,q:nat) (le n m)->(le p q)->(le (plus n p) (plus m q)).
Goal.
Intros n m p q H H0.
Elim H; Simpl; Auto.
Save.

Lemma le_plus_l : (n,m:nat)(le n (plus n m)).
Goal.
Induction n; Simpl; Auto.
Save.
Hint le_plus_l.

Lemma le_plus_r : (n,m:nat)(le m (plus n m)).
Goal.
Intros n m; Elim n; Simpl; Auto.
Save.
Hint le_plus_r.

Theorem le_plus_trans (n,m,p:nat)(le n m)->(le n (plus m p)).
Goal.
Intros; Apply le_trans with m; Auto.
Save.
Hint le_plus_trans.

Require Lt.

Lemma simpl_lt_plus_l : (n,m,p:nat)(lt (plus p n) (plus p m))->(lt n m).
Goal.
Induction p; Simpl; Auto.
Save.

Lemma lt_reg_l : (n,m,p:nat)(lt n m)->(lt (plus p n) (plus p m)).
Goal.
Induction p; Simpl; Auto.
Save.
Hint lt_reg_l.

Theorem lt_plus_trans : (n,m,p:nat)(lt n m)->(lt n (plus m p)).
Goal.
Intros; Apply lt_le_trans with m; Auto.
Save.
Immediate lt_plus_trans.

Provide Plus.
