(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                           Natural numbers                                 *)
(*                            Peano Axioms                                   *)
(*                                                                           *)
(*****************************************************************************)

Theorem eq_S : (n,m:nat)(<nat>n=m)-><nat>(S n)=(S m).
Goal.
Intros n m H ; Apply (f_equal nat) ; Auto.
Save.
Hint eq_S.

(* The predecessor function *)

Definition pred : nat->nat 
     = [n:nat](<nat>Match n with (* O *) O 
                               (* S u *) [u,v:nat]u).

Theorem pred_Sn : (m:nat)<nat>m=(pred (S m)).
Goal.
Auto.
Save.

Theorem eq_add_S : (n,m:nat)(<nat>(S n)=(S m))-><nat>n=m.
Goal.
Intros n m H ; Change <nat>(pred (S n))=(pred (S m)).
(*  <nat>(pred (S n))=(pred (S m))
    ============================
      H : <nat>(S n)=(S m)
      m : nat
      n : nat *)
Apply (f_equal nat) ; Auto.
Save.
Immediate eq_add_S.

(* A consequence of the previous axioms *)

Theorem not_eq_S : (n,m:nat)(~<nat>n=m)->~<nat>(S n)=(S m).
Goal.
Red; Intros n m H1 H2 ; Apply H1; Auto.
Save.
Hint not_eq_S.

Definition IsSucc : nat->Prop
  = [n:nat](<Prop>Match n with (* O *) False
                           (* S p *) [p:nat][P:Prop]True).

Theorem O_S : (n:nat)~(<nat>O=(S n)).
Goal.
Red ; Intros n H.
(*  False
    ============================
      H : <nat>O=(S n)
      n : nat *)
Change (IsSucc O) ; Rewrite H ; Simpl ; Auto.
Save.
Hint O_S.

Theorem n_Sn : (n:nat)~<nat>n=(S n).
Goal.
Induction n ; Auto.
Save.
Hint n_Sn.

(*************************************************)
(*      Addition                                 *)
(*************************************************)

Definition plus = [n,m:nat](<nat>Match n with 
      (* O *) m 
    (* S p *) [p,plus_p_m:nat](S plus_p_m)).

Lemma plus_n_O : (n:nat)<nat>n=(plus n O).
Goal.
Induction n ; Simpl ; Auto.
Save.
Hint plus_n_O.

Lemma plus_n_Sm : (n,m:nat) <nat>(S (plus n m))=(plus n (S m)).
Goal.
Intros m n; Elim m; Simpl; Auto.
Save.
Hint plus_n_Sm.

(***************************************)
(*      Multiplication                 *)
(***************************************)

Definition  mult = 
   [n,m:nat](<nat> Match n with (* O *) O 
                              (* S p *) [p:nat](plus m)).

Goal (n:nat)<nat>O=(mult n O).
Induction n; Simpl; Auto.
Save mult_n_O.

Goal (n,m:nat)<nat>(plus (mult n m) n)=(mult n (S m)).
Intros; Elim n; Simpl; Auto.
Intros p H; Rewrite H; Elim plus_n_Sm; Apply eq_S.
Pattern 1 3 m; Elim m; Simpl; Auto.
Save mult_n_Sm.

(***********************************************************************)
(* Definition of the usual orders, the basic properties of le and lt   *)
(* can be found in files Le and Lt                                     *)
(***********************************************************************)

(* An inductive definition to define the order *)

Inductive Definition le [n:nat] : nat -> Prop
    = le_n : (le n n)
    | le_S : (m:nat)(le n m)->(le n (S m)).

Hint le_n le_S.

Definition lt [n,m:nat](le (S n) m).
Hint Unfold lt.

Definition ge [n,m:nat](le m n).
Hint Unfold ge.

Definition gt [n,m:nat](lt m n).
Hint Unfold gt.

(*********************************************************)
(* Pattern-Matching on natural numbers                   *)
(*********************************************************)

Theorem nat_case : (n:nat)(P:nat->Prop)(P O)->((m:nat)(P (S m)))->(P n).
Goal.
Intros n P H H0 ; Elim n ; Auto.
Save.

(**********************************************************)
(* Principle of double induction                          *)
(**********************************************************)

Theorem nat_double_ind : (R:nat->nat->Prop)
     ((n:nat)(R O n)) -> ((n:nat)(R (S n) O))
     -> ((n,m:nat)(R n m)->(R (S n) (S m)))
     -> (n,m:nat)(R n m).
Goal.
Induction n; Trivial.
Induction m; Auto.
Save.

Provide Peano.
