(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      Multiplication                                                       *)
(*                                                                           *)
(*                                                                           *)
(*****************************************************************************)

Require Plus.
Require Minus.

(**********************************************************)
(* Multiplication                                         *)
(**********************************************************)

Lemma mult_plus_distr : (n,m,p:nat)<nat>(mult (plus n m) p)=(plus (mult n p) (mult m p)).
Goal.
Intros; Elim n; Simpl; Intros; Trivial.
Elim plus_assoc_l; Elim H; Auto.
Save.
Hint mult_plus_distr.

Lemma mult_minus_distr : (n,m,p:nat)<nat>(mult (minus n m) p)=(minus (mult n p) (mult m p)).
Goal.
Intros; Pattern n m; Apply nat_double_ind; Simpl; Intros; Trivial.
Elim minus_plus_simpl; Auto.
Save.
Hint mult_minus_distr.

Lemma mult_O_le : (n,m:nat)(<nat>m=O)\/(le n (mult m n)).
Goal.
Induction m; Simpl; Auto.
Save.
Hint mult_O_le.

Lemma mult_assoc_r : (n,m,p:nat)<nat>(mult (mult n m) p) = (mult n (mult m p)).
Goal.
Intros; Elim n; Intros; Simpl; Auto.
Rewrite mult_plus_distr.
Elim H; Auto.
Save.
Hint mult_assoc_r.

Provide Mult.

