Require Peano.

(*********************************************************)
(*    Subtraction                                        *)
(*********************************************************)

(* difference between two natural numbers *)
Definition minus = 
  [n:nat](<nat->nat> Match n with
               (* O *) [p:nat]O
             (* S k *) [k:nat][mink:nat->nat][p:nat]
                             (<nat> Match p with
                                  (* O *)    (S k)
                                (* S l *)    [l:nat][minSkl:nat](mink l))).

Lemma minus_plus_simpl : (n,m,p:nat)<nat>(minus n m)=(minus (plus p n) (plus p m)).
Goal.
Induction p; Simpl; Auto.
Save.
Hint minus_plus_simpl.

Lemma minus_n_O : (n:nat)<nat>n=(minus n O).
Goal.
Induction n; Simpl; Auto.
Save.
Hint minus_n_O.

Lemma minus_n_n : (n:nat)<nat>O=(minus n n).
Goal.
Induction n; Simpl; Auto.
Save.
Hint minus_n_n.

Lemma plus_minus : (n,m,p:nat)(<nat>n=(plus m p))-><nat>p=(minus n m).
Goal.
Intros n m p; Pattern m n; Apply nat_double_ind; Simpl; Intros.
Replace (minus n0 O) with n0; Auto.
Absurd <nat>O=(S (plus n0 p)); Auto.
Auto.
Save.
Immediate plus_minus.


Require Le.

Lemma le_plus_minus : (n,m:nat)(le n m)-><nat>m=(plus n (minus m n)).
Goal.
Intros n m Le; Pattern n m; Apply le_elim_rel; Simpl; Auto.
Save.
Hint le_plus_minus.

Lemma minus_Sn_m : (n,m:nat)(le m n)-><nat>(S (minus n m))=(minus (S n) m).
Goal.
Intros n m Le; Pattern m n; Apply le_elim_rel; Simpl; Auto.
Save.
Hint minus_Sn_m.

Require Lt.

Lemma lt_minus : (n,m:nat)(le m n)->(lt O m)->(lt (minus n m) n).
Goal.
Intros n m Le; Pattern m n; Apply le_elim_rel; Simpl; Trivial.
Intros; Absurd (lt O O); Auto.
Intros p q lepq Hp gtp.
Elim (le_lt_or_eq O p); Trivial.
Auto.
Induction 1; Elim minus_n_O; Auto.
Save.
Hint lt_minus.

Lemma lt_O_minus_lt : (n,m:nat)(lt O (minus n m))->(lt m n).
Goal.
Intros n m; Pattern n m; Apply nat_double_ind; Simpl; Auto.
Intros; Absurd (lt O O); Trivial.
Save.
Immediate lt_O_minus_lt.
Provide Minus.
