(* minimum of two natural numbers *)

Definition min = [n:nat]
      (<nat->nat>Match n with 
      (* O *) [m:nat]O
   (* S n' *) [n':nat][minn':nat->nat][m:nat]
              (<nat>Match m with 
              (* O *) O 
           (* S m' *) [m':nat][minSn'm':nat](S (minn' m')))).

Lemma min_SS : (n,m:nat)<nat>(S (min n m))=(min (S n) (S m)).
Goal.
Auto.
Save.

Lemma le_min_l : (n,m:nat)(le (min n m) n).
Goal.
Induction n; Intros; Simpl; Auto.
Elim m; Intros; Simpl; Auto.
Save.
Hint le_min_l.

Lemma le_min_r : (n,m:nat)(le (min n m) m).
Goal.
Induction n; Simpl; Auto.
Induction m; Simpl; Auto.
Save.
Hint le_min_r.

(* min n m is equal to n or m *)

Lemma min_case : (n,m:nat)(P:nat->Set)(P n)->(P m)->(P (min n m)).
Goal.
Induction n; Simpl; Auto.
Induction m; Intros; Simpl; Auto.
Pattern (min y y0); Apply H ; Auto.
Save.

Provide Min.