Require Le.

Theorem lt_n_Sn : (n:nat)(lt n (S n)).
Goal.
Auto.
Save.
Hint lt_n_Sn.

Theorem lt_S : (n,m:nat)(lt n m)->(lt n (S m)).
Goal.
Auto.
Save.
Hint lt_S.

Theorem lt_n_S : (n,m:nat)(lt n m)->(lt (S n) (S m)).
Goal.
Auto.
Save.
Hint lt_n_S.

Theorem lt_S_n : (n,m:nat)(lt (S n) (S m))->(lt n m).
Goal.
Auto.
Save.
Immediate lt_S_n.

Theorem lt_O_Sn : (n:nat)(lt O (S n)).
Goal.
Auto.
Save.
Hint lt_O_Sn.

Theorem lt_n_O : (n:nat)~(lt n O).
Proof le_Sn_O.
Hint lt_n_O.

Theorem lt_n_n : (n:nat)~(lt n n).
Proof le_Sn_n.
Hint lt_n_n.

Lemma S_pred : (n,m:nat)(lt m n)-><nat>n=(S (pred n)).
Goal.
Induction 1; Auto.
Save.

Lemma lt_pred : (n,p:nat)(lt (S n) p)->(lt n (pred p)).
Goal.
Induction 1; Simpl; Auto.
Save.
Immediate lt_pred.

(* Relationship between le and lt *) 

Theorem lt_le_S : (n,p:nat)(lt n p)->(le (S n) p).
Goal.
Auto.
Save.
Immediate lt_le_S.

Theorem lt_n_Sm_le : (n,m:nat)(lt n (S m))->(le n m).
Goal.
Auto.
Save.
Immediate lt_n_Sm_le.

Theorem le_lt_n_Sm : (n,m:nat)(le n m)->(lt n (S m)).
Goal.
Auto.
Save.
Immediate le_lt_n_Sm.

Theorem lt_le_weak : (n,m:nat)(lt n m)->(le n m).
Goal.
Auto.
Save.
Immediate lt_le_weak.

Theorem neq_O_lt : (n:nat)(~<nat>O=n)->(lt O n).
Goal.
Induction n; Auto.
Intros; Absurd <nat>O=O; Trivial.
Save.
Immediate neq_O_lt.

Theorem lt_O_neq : (n:nat)(lt O n)->(~<nat>O=n).
Goal.
Induction 1; Auto.
Save.
Immediate lt_O_neq.

(* Transitivity properties *)

Theorem lt_trans : (n,m,p:nat)(lt n m)->(lt m p)->(lt n p).
Goal.
Induction 2; Auto.
Save.

Theorem lt_le_trans : (n,m,p:nat)(lt n m)->(le m p)->(lt n p).
Goal.
Induction 2; Auto.
Save.

Theorem le_lt_trans : (n,m,p:nat)(le n m)->(lt m p)->(lt n p).
Goal.
Induction 2; Auto.
Save.

Theorem le_lt_or_eq : (n,m:nat)(le n m)->((lt n m) \/ <nat>n=m).
Goal.
Induction 1; Auto.
Save.

Theorem le_or_lt : (n,m:nat)((le n m)\/(lt m n)).
Goal.
Intros n m; Pattern n m; Apply nat_double_ind; Auto.
Induction 1; Auto.
Save.

Theorem le_not_lt : (n,m:nat)(le n m)->~(lt m n).
Goal.
Induction 1; Auto.
Red; Intros m0 H1 H2 H3; Apply H2; Auto.
Save.
Immediate le_not_lt.

Theorem lt_not_le : (n,m:nat)(lt n m)->~(le m n).
Goal.
Red; Intros n m Lt Le; Exact (le_not_lt m n Le Lt).
Save.
Immediate lt_not_le.

Theorem lt_not_sym : (n,m:nat)(lt n m)->~(lt m n).
Goal.
Induction 1; Auto.
Red; Intros p H1 H2 H3; Apply H2; Auto.
Save.

Provide Lt.
