Require Peano.

(***************************************)
(* Order on natural numbers            *)
(***************************************)

Section less_or_equal.
Variable n,m,p:nat.

Theorem le_n_S : (le n m)->(le (S n) (S m)).
Goal.
Intro H.
(*  (le (S n) (S m))
    ============================
      H : (le n m) *)
Elim H ; Auto.
Save.

Theorem le_trans : (le n m)->(le m p)->(le n p).
Goal.
Intros H H0.
(*  (le n p)
    ============================
      H0 : (le m p)
      H : (le n m) *)
Elim H0 ; Auto.
Save.

Theorem le_n_Sn : (le n (S n)).
Goal.
Auto.
Save.

Theorem le_O_n : (le O n).
Goal.
Elim n ; Auto.
Save.

End less_or_equal.
Hint le_n_S le_n_Sn le_O_n.

Theorem le_pred_n : (n:nat)(le (pred n) n).
Goal.
Induction n ; Auto.
Save.
Hint le_pred_n.

Theorem le_trans_S : (n,m:nat)(le (S n) m)->(le n m).
Goal.
Intros n m H ; Apply le_trans with (S n) ; Auto.
Save.
Immediate le_trans_S.

Theorem le_S_n : (n,m:nat)(le (S n) (S m))->(le n m).
Goal.
Intros n m H ; Change (le (pred (S n)) (pred (S m))).
(*  (le (pred (S n)) (pred (S m)))
    ============================
      H : (le (S n) (S m))
      m : nat
      n : nat *)
Elim H ; Simpl ; Auto.
Save.
Immediate le_S_n.

(* Negative properties *)

Theorem le_Sn_O : (n:nat)~(le (S n) O).
Goal.
Red ; Intros n H.
(*  False
    ============================
      H : (lt n O)
      n : nat *)
Change (IsSucc O) ; Elim H ; Simpl ; Auto.
Save.
Hint le_Sn_O.

Theorem le_Sn_n : (n:nat)~(le (S n) n).
Goal.
Induction n; Trivial.
Red; Intros m H H'; Apply H; Auto.
Save.
Hint le_Sn_n.

Theorem le_antisym : (n,m:nat)(le n m)->(le m n)-><nat>n=m.
Goal.
Intros n m h ; Elim h ; Trivial.
(*  (m:nat)(le n m)->((le m n)->(<nat>n=m))->(le (S m) n)->(<nat>n=(S m))
    ============================
      h : (le n m)
      m : nat
      n : nat *)
Intros m0 H H0 H1.
Absurd (le (S m0) m0) ; Auto.
(*  (le (S m0) m0)
    ============================
      H1 : (le (S m0) n)
      H0 : (le m0 n)->(<nat>n=m0)
      H : (le n m0)
      m0 : nat *)
Apply le_trans with n ; Auto.
Save.
Immediate le_antisym.

Theorem le_n_O_eq : (n:nat)(le n O)-><nat>O=n.
Goal.
Auto.
Save.
Immediate le_n_O_eq.


(* A different elimination principle for the order on natural numbers *)

Lemma le_elim_rel : (P:nat->nat->Prop)
     ((p:nat)(P O p))->
     ((p,q:nat)(le p q)->(P p q)->(P (S p) (S q)))->
     (n,m:nat)(le n m)->(P n m).
Goal.
Induction n; Trivial.
Intros n' HRec m Le.
Elim Le; Auto.
Save.

Provide Le.