(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*     Properties of gt                                                      *)
(*                                                                           *)
(*****************************************************************************)

Require Lt.

Theorem gt_Sn_O : (n:nat)(gt (S n) O).
Goal.
Auto.
Save.
Hint gt_Sn_O.

Theorem gt_Sn_n : (n:nat)(gt (S n) n).
Goal.
Auto.
Save.
Hint gt_Sn_n.

Theorem le_S_gt : (n,m:nat)(le (S n) m)->(gt m n).
Goal.
Auto.
Save.
Immediate le_S_gt.

Theorem gt_n_S : (n,m:nat)(gt n m)->(gt (S n) (S m)).
Goal.
Auto.
Save.
Hint gt_n_S.

Theorem gt_trans_S : (n,m,p:nat)(gt (S n) m)->(gt m p)->(gt n p).
Goal.
Red; Intros; Apply lt_le_trans with m; Auto.
Save.

Theorem le_gt_trans : (n,m,p:nat)(le m n)->(gt m p)->(gt n p).
Goal.
Red; Intros; Apply lt_le_trans with m; Auto.
Save.

Theorem gt_le_trans : (n,m,p:nat)(gt n m)->(le p m)->(gt n p).
Goal.
Red; Intros; Apply le_lt_trans with m; Auto.
Save.

Lemma le_not_gt : (n,m:nat)(le n m)->~(gt n m).
Proof le_not_lt.
Hint le_not_gt.

Lemma gt_antirefl : (n:nat)~(gt n n).
Proof lt_n_n.
Hint gt_antirefl.

Lemma gt_not_sym : (n,m:nat)(gt n m)->~(gt m n).
Proof [n,m:nat](lt_not_sym m n).

Lemma gt_not_le : (n,m:nat)(gt n m)->~(le n m).
Goal.
Auto.
Save.
Hint gt_not_le.

Lemma gt_trans : (n,m,p:nat)(gt n m)->(gt m p)->(gt n p).
Goal.
Red; Intros n m p H1 H2.
Apply lt_trans with m; Auto.
Save.

Lemma gt_S_n : (n,p:nat)(gt (S p) (S n))->(gt p n).
Goal.
Auto.
Save.
Immediate gt_S_n.

Lemma gt_S_le : (n,p:nat)(gt (S p) n)->(le n p).
Goal.
Intros n p; Exact (lt_n_Sm_le n p).
Save.
Immediate gt_S_le.

Lemma gt_le_S : (n,p:nat)(gt p n)->(le (S n) p).
Goal.
Auto.
Save.
Hint gt_le_S.

Lemma le_gt_S : (n,p:nat)(le n p)->(gt (S p) n).
Goal.
Auto.
Save.
Hint le_gt_S.

Lemma gt_pred : (n,p:nat)(gt p (S n))->(gt (pred p) n).
Goal.
Auto.
Save.
Immediate gt_pred.

Theorem gt_S : (n,m:nat)(gt (S n) m)->((gt n m)\/(<nat>m=n)).
Goal.
Intros n m H; Unfold gt; Apply le_lt_or_eq; Auto.
Save.

Theorem gt_O_eq : (n:nat)((gt n O)\/(<nat>O=n)).
Goal.
Intro n ; Apply gt_S ; Auto.
Save.

Require Plus.

Lemma simpl_gt_plus_l : (n,m,p:nat)(gt (plus p n) (plus p m))->(gt n m).
Goal.
Red; Intros n m p H; Apply simpl_lt_plus_l with p; Auto.
Save.

Lemma gt_reg_l : (n,m,p:nat)(gt n m)->(gt (plus p n) (plus p m)).
Goal.
Auto.
Save.
Hint gt_reg_l.

Provide Gt.
