(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*                           Division		                             *)
(*     Examples of the program tactic - Catherine Parent June 92             *)
(*									     *)
(*****************************************************************************)

Require Compare_dec.
Require Mult.

Definition inf_dec: nat->nat->bool =
        [n:nat](<nat->bool> Match n with
                [m:nat] true
                [n':nat][H:nat->bool][m:nat]
                        (<bool> Match m with 
                                false 
                                [m':nat][H':bool](H m'))).

Inductive Definition diveucl [a,b:nat] : Set 
  = divex : (q,r:nat)(gt b r)->(<nat>a=(plus (mult q b) r))->(diveucl a b).

Goal (b:nat)(gt b O)->(a:nat)(diveucl a b).

(* Version 1 without annotations *)
Realizer [b,a:nat](<nat*nat> Match a with
 		      (* O *) <nat,nat>(O,O)
		      (* S *) [n:nat][H:nat*nat]
			(<nat*nat>let (q,r:nat) = H in
					<nat*nat> if (le_gt_dec b (S r)) then
						<nat,nat>((S q),O)
						  else
						<nat,nat>(q,(S r)))).
Program_all.
Rewrite e.
Replace b with (S r).
Simpl.
Elim plus_n_O; Auto.
Apply le_antisym; Auto.
Elim plus_n_Sm; Auto.
Save div1.

Goal (b:nat)(gt b O)->(a:nat)(diveucl a b).

(* Version 2 *)
Realizer [b,a:nat]
  (<nat*nat> Match a with
   (* O *) <nat,nat>(O,O)
   (* S *) [n:nat][H:nat*nat]
   	  (<nat*nat>let (q,r:nat) = H in
	(<nat*nat>if (inf_dec b (S r)) (: {(le b (S r))}+{(gt b (S r))} :) 
                  then <nat,nat>((S q),O) else <nat,nat>(q,(S r))))).
Program_all.
Rewrite e.
Replace b with (S r).
Simpl.
Elim plus_n_O; Auto.
Apply le_antisym; Auto.
Elim plus_n_Sm; Auto.
Save div2.

Provide Div.
