(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                           Natural numbers                                 *)
(*                       Programs for comparisons                            *)
(*                                                                           *)
(*****************************************************************************)


Require Lt.

Theorem lt_eq_lt_dec : (n,m:nat){(lt n m)}+{<nat>n=m}+{(lt m n)}.
Goal.
Induction n; Induction m; Auto.
Intros q H'; Elim (H q).
Induction 1; Auto.
Auto.
Save.

Lemma gt_eq_gt_dec : (n,m:nat)({(gt m n)}+{<nat>n=m})+{(gt n m)}.
Proof lt_eq_lt_dec.

Lemma le_lt_dec : (n,m:nat) {le n m} + {lt m n}.
Goal.
Induction n.
Auto.
Induction m.
Auto.
Intros q H'; Elim (H q); Auto.
Save.

Lemma le_le_S_dec : (n,m:nat) {le n m} + {le (S m) n}.
Proof le_lt_dec.

Lemma le_ge_dec : (n,m:nat) {le n m} + {ge n m}.
Goal.
Intros; Elim (le_lt_dec n m); Auto.
Save.

Theorem le_gt_dec : (n,m:nat){(le n m)}+{(gt n m)}.
Proof le_lt_dec.


Theorem le_lt_eq_dec : (n,m:nat)(le n m)->({(lt n m)}+{<nat>n=m}).
Goal.
Intros; Elim (lt_eq_lt_dec n m); Trivial.
Intros; Absurd (lt m n); Auto.
Save.

Provide Compare_dec.
