(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      Arithmetic                                                           *)
(*                                                                           *)
(*      Compare : More properties of eq, le and gt                           *)
(*                                                                           *)
(*****************************************************************************)

(********************************************)
(* equality is decidable on nat             *)
(********************************************)


Lemma not_eq_sym : (A:Set)(p,q:A)(~<A>p=q)->~<A>q=p.
Proof sym_not_equal.
Immediate not_eq_sym.

Require Gt.
Require Peano_dec.
Require Compare_dec.

Definition le_or_le_S = le_le_S_dec.

Definition compare = gt_eq_gt_dec.

Lemma le_dec : (n,m:nat) {le n m} + {le m n}.
Proof le_ge_dec.

Definition lt_or_eq = [n,m:nat]{(gt m n)}+{(<nat>n=m)}.

Lemma le_decide : (n,m:nat)(le n m)->(lt_or_eq n m).
Proof le_lt_eq_dec.

Lemma le_le_S_eq : (p,q:nat)(le p q)->((le (S p) q)\/<nat>p=q).
Proof le_lt_or_eq.

Require Wf_nat.

Require Min.

Provide Compare.
