(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             vernac.mli                                   *)
(****************************************************************************)

#open "std";;
#open "lexer";;
#open "program";;
#open "tactics";;
#open "command";;

type vernac_keyword;;

value vernac_keywords : (string * vernac_keyword) list vect;;
value rev_vernac_keywords : (vernac_keyword * string) list vect;;

value parse_vernac : vernac_keyword token stream -> unit;;
value forward_load_vernacular : (string -> unit) nref;;
value forward_load_vernacular_from_loadpath : (string -> unit) nref;;
value forward_load_vernacular_noisily : (string -> unit) nref;;
value forward_goX : (string -> unit) nref;;

(* DEBUG *)
value annotation : vernac_keyword token stream -> annoted_command;;
value lannotation : vernac_keyword token stream -> annoted_command;;
value simple_annotation : vernac_keyword token stream -> annoted_command;;
value command : vernac_keyword token stream -> command__command;;
value current_goal : unit -> int;;

(* Centaur Interface *)
value require_default : string -> string -> unit;;
value set_require_fun : (string -> string -> unit) -> unit;;
value reset_require_fun : unit -> unit;;
