(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              verify.ml                                   *)
(****************************************************************************)
#infix "o";;
#open "std";;
#open "initial";;
#open "univ";;
#open "extraction";;
#open "term";;
#open "search";;
#open "printer";;
#open "machine";;
#open "matching";;
#open "trad";;
#open "command";;
#open "genterm";;
#open "gentermio";;
#open "gen_command";;
#open "tactics";;
#open "more_util";;

type gen_decl == identifier * param genterm;;
type gen_sequent == param genterm * (gen_decl list);;

let genify_com_decl (Name(id),t) = (id,gen_cmd t);;

let genify_constr_decl (Name(id),t) = (id,genify (type_of t));;

let genify_com_sequent (sig,c) =
    (map genify_com_decl sig,gen_cmd c)
;;

let genify_constr_sequent(_,sig,c) =
    (map genify_constr_decl sig,genify c)
;;

let rec prodify_gen_sequent (assums,concl) = prodify assums
    where rec prodify = function 
    [] -> concl
  | ((id,assum)::rest_hyps) ->
    OP("PROD",[],[assum;
                  SLAM([SOME id],prodify rest_hyps)])
;;

let verify_state com_seql =
    try (for_all alpha_eq
    (combine(map (prodify_gen_sequent o genify_com_sequent) com_seql,
             map (prodify_gen_sequent o genify_constr_sequent) (list_pf(get_goals())))))
    & (for_all (fun ((l1,_),(_,l2,_)) -> length l1 = length l2)
       (combine(com_seql,list_pf(get_goals()))))
    with _ -> false
;;

let coqpr_gen_decl (id,t) =
    [< '(string_of_id id) ; '" : (" ; coqpr_genterm t ; '")\n" >]
;;

let coqpr_gen_sequent (sig,c) =
    [< '"(" ; coqpr_genterm c ;
       '")\n" ;
       '(if sig = [] then "" else "============\n") ;
       prlist coqpr_gen_decl sig >]
;;

let coqpr_gen_goals =
    prlist_with_sep (fun () -> [< '"||" >]) coqpr_gen_sequent
;;

let pr_gen_decl (id,t) =
    [< 'id ; '" : (" ; pr_genterm t ; '")\n" >]
;;

let pr_gen_sequent (sig,c) =
    [< '"(" ; pr_genterm c ;
       '")\n" ;
       '(if sig = [] then "" else "============\n") ;
       prlist pr_gen_decl sig >]
;;

let pr_gen_goals =
    prlist_with_sep (fun () -> [< '"||" >]) pr_gen_sequent
;;

let make_verify_command () =
    string_stream_to_string
    [< '"Verify " ;
       coqpr_gen_goals (map genify_constr_sequent (list_pf(get_goals()))) ;
       '"." >]
;;

let verify_goal () = 
    string_stream_to_string(coqpr_gen_goals (map genify_constr_sequent (list_pf(get_goals()))));;

let print_state () =
    output_string_stream (coqpr_gen_goals (map genify_constr_sequent (list_pf(get_goals()))))
;;



let transcript = ref false;;

let set_transcript b = (transcript := b;());;
