(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                               trad.ml                                    *)
(****************************************************************************)

(* A translator of commands into terms, used by the prover when finished *)

#infix "o";;
#open "std";;
#open "univ";;
#open "initial";;
#open "extraction";;
#open "term";;
#open "machine";;
#open "command";;

let assoc_sign str = assrec
where rec assrec = function
   [] -> raise Not_found
 | (Name s,c)::l -> if s=str then c else assrec(l)
 | _ -> raise Not_found;;

(* constr_of_com : signature -> command -> constr *)
let constr_of_com = crec where rec crec vl = crecvl where rec
 crecvl = function
  RefC(str) -> (try assoc_sign str vl with Not_found ->
    (try val_of str with Undeclared -> error((string_of_id str)^"  not declared")))
| PropC(c) -> Prop(c)
| TypeC(c) -> Type(c,New_univ())
| AppC(c1,c2) -> App(crecvl c1,crecvl c2)
| LambdaC(s,c1,c2) -> (let u1 = crecvl c1 and name = Name(s) in
    lambda name u1 (crec ((name,creation_var name u1)::vl) c2))
| ProdC(s,c1,c2) -> (let u1 = crecvl c1 and name = Name(s) in
    produit name u1 (crec ((name,creation_var name u1)::vl) c2))
| ArrowC(c1,c2) -> Prod(Anonymous,crecvl c1,lift 1 (crecvl c2))
| ConstrC(i,c)  -> Construct(i,crecvl c)
| IndC(stamp,s,c,l)   -> let t = crecvl c and name = Name(s) in
                   let v = (name,creation_var name t) in 
                   make_ind stamp t (map (subst_var name o (crec (v::vl))) l)
| ElimCdep(c,k,lc)  -> make_elim_dep (crecvl c) (crecvl k) (map crecvl lc)
| ElimCnodep(c,k)   -> make_elim_nodep (crecvl c) (crecvl k)
| ElimC(c,P)     -> make_elim_val (crecvl c) (crecvl P)
| LetC(s,c1,c2) -> subst_norm s (crec vl c1) (crec vl c2)
;;


