#open "unix";;
#open "pp";;
#open "stdpp";;
let zero x = (x := 0);;

#open "float";;

let utime () = (times()).tms_utime;;
type counter = {mutable cumul : float; mutable from : float; calls : int ref};;

let make_ctr () = {cumul = 0.0; calls = ref 0 ; from = 0.0};;

let init ctr = (ctr.cumul <- 0.0;
                zero ctr.calls);;

let start ctr = (ctr.from <- utime());;

let stop ctr = (ctr.cumul <- ctr.cumul + (utime() - ctr.from);
                incr ctr.calls);;

let retime ctr f x =
begin
 start ctr;
 let retv = f x in
 (stop ctr; retv)
end;;

let report s ctr = PPNL [< 'S"Cumulative for " ; 'S s ; 'S" Calls= " ; 'INT !(ctr.calls) ; 'S " Time= " ; 'REAL (ctr.cumul) >];;

let construct_1_ctr = make_ctr();;
let construct_2_ctr = make_ctr();;
let construct_3_ctr = make_ctr();;
let recursive_ctr = make_ctr();;
let recursive_snd_part = make_ctr();;
let dep_exec = make_ctr();;
let nodep_exec = make_ctr();;
let dep_elim_exec = make_ctr();;
let nodep_elim_exec = make_ctr();;
let execute_ctr = make_ctr();;
let build_ctr = make_ctr();;
let inductype_spec_ctr = make_ctr();;

let init_all() =
    (map init [construct_1_ctr;
               construct_2_ctr;
               construct_3_ctr;
               recursive_ctr;
               recursive_snd_part;
               execute_ctr;
               inductype_spec_ctr;
               dep_exec;
               nodep_exec;
               dep_elim_exec;
               nodep_elim_exec;
               build_ctr]);;

let report_all () = (report "recursive" recursive_ctr;
                     report "recursive 2nd part" recursive_snd_part;
                     report "construct_1" construct_1_ctr;
                     report "construct_2" construct_2_ctr;
                     report "construct_3" construct_3_ctr;
                     report "execute" execute_ctr;
                     report "inductype_spec" inductype_spec_ctr;
                     report "dep_exec" dep_exec;
                     report "nodep_exec" nodep_exec;
                     report "dep_elim_exec" dep_elim_exec;
                     report "build" build_ctr;
                     report "nodep_elim_exec" nodep_elim_exec);;

