(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             termfw.mli                                   *)
(****************************************************************************)

#open "initial";;

type fterm =
    Fvar of name * fterm                  (* free variables *)
  | Fconst of name * fterm                (* constants *)
  | Frel of int                           (* variables *)
  | Fomega                                (* proposition types *)
  | Fapp of fterm * fterm                 (* application  (M N) *)
  | Flambda of name * fterm * fterm       (* abstraction  [x:T]M *)
  | Fprod of name * fterm * fterm         (* product      (x:T)M *)
  | Find of name * fterm * fterm list * fspecifr * fterm list
  | Fconstr of int * fterm
  | Frec of fterm list * fterm 
  | Fimplicit
and fspecifr = Fspecifr of int * (int * fterm) list
;;

type freference =
     Flocal of int
   | Fglobal of name * fterm;;

type fapproximation =
     Fabstraction of fterm * fterm
   | Fproduct of fterm * fterm
   | Fvariable of freference * fterm list
   | Fconstant of (name * fterm) * fterm list
   | Finductive of name * fterm * fterm list * fterm list
   | Fconstructor of int * fterm * fterm list
   | Felimination of fterm list * fterm list
   | Fomegaconst
   | Fimplicitconst;;

exception Omega;;
exception Occur;;
exception Felim;;
exception Finduc;;


value foccurn : int -> fterm -> bool;;
value fabs_implicit : fterm -> fterm;;
value fredapplist : fterm -> fterm list -> fterm;;
value fmake_rec : fterm list -> int -> fterm;;
value fred_elimination : fterm list * fterm -> fterm;;
value fexpand : fapproximation -> fapproximation;;
value fapprox : fterm list -> fterm -> fapproximation;;
value fapproxim : fterm -> fapproximation;;
value flift : int -> fterm -> fterm;;
value fpop : fterm -> fterm;;
value fsubst1 : fterm -> fterm -> fterm;;
value fsubst_var : name -> fterm -> fterm;;
value foccur_eq : identifier -> fterm -> bool;;
value fglobals : fterm -> identifier list;;
value find_finductype : fterm -> (name * fterm * fterm list * fspecifr * fterm list) * fterm list;;
value fnf : fterm -> fterm;;
value fsubst_norm : identifier -> fterm -> fterm -> fterm;;
value fconv : fterm -> fterm -> bool;;
value fmake_ind : name -> fterm -> fterm list -> fterm;;
value fmake_elim : fterm -> fterm;;
value ftype_constr : fterm list -> fterm -> fterm;;
value ftype_term : fterm list -> fterm -> fterm;;
value ftype_of : fterm -> fterm;;
value farity : fterm -> fterm list -> int;;
value is_ftype : fterm -> fterm list -> bool;;
value fmake_elimination : fterm -> fterm -> fterm;;
value freduce : fterm -> fterm * fterm list;;
value fapplist : fterm -> fterm list -> fterm;;
value fliftn : int -> int -> fterm -> fterm;;
value ftype_elim_args : fterm -> fterm -> fterm list -> fterm list;;
value frel_list : int -> int -> fterm list;;
value finductype : fterm -> name * fterm * fterm list * fspecifr * fterm list;;
value freduce_app : fterm -> fterm * fterm list;;
