(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              term.mli                                     *)
(****************************************************************************)

#open "std";;
#open "extraction";;
#open "univ";;
#open "initial";;
#open "pp";;
#open "stdpp";;

type constr =
    Meta of int list                   (* meta-variables (for synthesis) *)
  | Var of variable                    (* free variables *)
  | Const of constant                  (* constants *)
  | Rel of int                         (* variables *)
  | Prop of contents                   (* proposition types *)
  | Type of contents * universe        (* universes *)
  | App of constr * constr             (* application  (M N) *)
  | Lambda of name * constr * constr   (* abstraction  [x:T]M *)
  | Prod of name * constr * constr     (* product      (x:T)M *)
  | Ind of name * constr * constr list * specifr * specift
                                       (* inductive type *)
  | Construct of int * constr          (* constructor *)
  | Rec of bool * constr list * constr (* elimination *)
  | Implicit
and specifr = Specifr of int * (int * constr) list
and specift = Specift of (constr list * constr list)
                       * (constr list * constr list)
and variable = Decl of name * judgement * information
                                       (* variable declarations *)
and constant = Def of name * judgement * information
                                       (* constant definitions *)
and judgement = Judge of constr * constr * level;;

value forward_prterm : (constr -> std_ppcmds) nref;;

value dependent : int -> constr -> bool;;

value typep : constr;;
value types : constr;;
value data : constr;;
value spec : constr;;
value prop : constr;;
value lift : int -> constr -> constr;;
value subst1 : constr -> constr -> constr;;
value subst_var : name -> constr -> constr;;
value applist : constr -> constr list -> constr;;
value produit : name -> constr -> constr -> constr;;
value lambda : name -> constr -> constr -> constr;;
value occur : identifier -> constr -> bool;;
value occur_eq : identifier -> constr -> bool;;
value occur_name : name -> constr -> bool;;
value globals : constr -> identifier list;;
value value_of : constant -> constr;;
value info_of : constr -> information;;
value simplify : constr -> constr;;
value subst_norm : identifier -> constr -> constr -> constr;;
value unfoldn : int list -> identifier -> constr -> constr;;
value nf : constr -> constr;;
value conv_leq : constr -> constr -> bool;;
value hnftype : constr -> constr;;
value level_of_kind : constr -> level;;
value red_product : constr -> constr;;
value hnf_constr : constr -> constr;;
value conv_x : constr -> constr -> bool;;
value subst_term_occ : int list -> constr -> constr -> constr;;
value type_construct : int -> constr -> constr;;
value type_wfconstr : constr list -> constr -> constr;;
value hdchar : constr -> string;;
value named_hd : constr -> name -> name;;
value lev_of_ind : constr -> level;;
value make_ind : name -> constr -> constr list -> constr;;
value type_elim : constr -> constr list -> bool -> constr -> constr -> constr;;
value type_constr : constr list -> constr -> constr;;
value type_of : constr -> constr;;
value one_step_reduce : constr -> constr;;
value find_induc_comb : constr -> constr * constr list;;
value make_elim_dep : constr -> constr -> constr list -> constr;;
value make_elim_nodep : constr -> constr -> constr;;
value make_elim : constr -> constr -> constr -> constr -> (constr * constr) * level;;
value make_elim_val : constr -> constr -> constr;;
value possible_elim : constr -> constr list * constr list;;
value closed : constr -> bool;;
value reduce : constr -> constr * constr list;;
value make_ind_rel : name -> constr list -> constr -> constr list -> constr;;
value eq_constr : constr * constr -> bool;;
value prod_name : name * constr * constr -> constr;;
value subst_term : constr -> constr -> constr;;
value arrow : constr -> constr -> constr;;
value noccurn : int -> constr -> bool;;
value find_inductype : constr -> (name * constr * constr list * specifr * specift) * constr list;;
value liftn : int -> constr -> int -> constr;;
