(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             tactics.mli                                  *)
(****************************************************************************)

#open "initial";;
#open "term";;
#open "command";;

type record_mode = Context | Delayed | Flush | Invisible;;

type signature == (name * constr) list;;

type goal == (int list) * signature * constr;;

type prooftree =
    INTRO of name * constr * prooftree
 |  APP of prooftree list
 |  PF of constr
 |  INCOMPLET of (int list) * signature * constr;;

type tactic == goal -> prooftree;;

value list_pf : prooftree -> goal list;;
value apply_tac : tactic -> prooftree -> prooftree;;
value IDTAC : tactic;;
value ORELSE : tactic -> tactic -> tactic;;
value NEXT : tactic -> (prooftree -> prooftree) -> tactic;;
value THEN : tactic -> tactic -> tactic;;
value THENF : tactic -> tactic -> tactic;;
value THENL : tactic -> tactic -> tactic;;
value THENS : tactic -> tactic list -> tactic;;
value REPEAT : tactic -> tactic;;
value FIRST : tactic list -> tactic;;
value TRY : tactic -> tactic;;
value COMPLETE : tactic -> tactic;;
value AT_LEAST_ONE : tactic -> tactic;;
value FAILTAC : tactic;;
value DO : int -> tactic -> tactic;;
value get_goals : unit -> prooftree;;
value get_goal : unit -> goal;;
value UNDO : prooftree list ref;;
value undo_limit : int ref;;
value refining : unit -> bool;;
value open_vernacular : string -> unit;;
value close_vernacular : unit -> unit;;
value set_record : record_mode -> unit;;
value record_line : string -> int -> unit;;
value top_thm : unit -> constr;;
value Undo : int -> unit;;
value print_subgoal : int -> unit;;
value set_print_fun : (unit -> unit) -> unit;;
value reset_print_fun : unit -> unit;;
value set_show_fun : (unit -> unit) -> unit;;
value show : unit -> unit;;
value show_proof : unit -> unit;;
value save_named : unit -> unit;;
value save_anonymous_thm : string -> unit;;
value save_anonymous_remark : string -> unit;;
value cast_to_postulate : unit -> unit;;
value abort_goals : unit -> unit;;
value restart : unit -> unit;;
value reset_section : string -> unit;;
value intro_global : tactic;;
value intros_global : tactic;;
value reset_all : unit -> unit;;
value restore_state : string -> unit;;
value save_state : string -> string -> unit;;
value reset_keeping_name : identifier -> unit;;
value reset_name : identifier -> unit;;
value reset_initial : unit -> unit;;
value reset_prelude : unit -> unit;;
value goal_mode : unit -> unit;;
value solve : int -> tactic -> unit;;
value by : tactic -> unit;;
value tactic_com : (constr -> tactic) -> command -> tactic;;
value intro : tactic;;
value intros : tactic;;
value intros_with : identifier list -> tactic;;
value intros_until : identifier -> tactic;;
value intro_with_id : string -> tactic;;
value intros_with_id : string -> tactic;;
value resolve : command -> tactic;;
value resolvew : command -> tactic;;
value resolve_type : command -> tactic;;
value cut : command -> tactic;;
type BindOcc = 
    Dep of identifier
  | NoDep of int
;;
value new_hyp : command -> int list * (name * constr) list * constr -> prooftree;;
value new_hyp_with : command -> (BindOcc * command) list -> int list * (name * constr) list * constr -> prooftree;;
value new_hyp_with_num : int -> command -> (BindOcc * command) list -> int list * (name * constr) list * constr -> prooftree;;
value generalize : command list -> tactic;;
value resolve_with : command list -> tactic;;
value resolve_with_name : command -> (BindOcc * command) list -> tactic;;
value imp_elim_tac : command -> tactic;;
value assumption : tactic;;
value instantiate : int -> command -> unit;;
value give_exact_com : command -> tactic;;
value change : command -> tactic;;
value red : tactic;;
value hnf_tac : tactic;;
value simpl_tac : tactic;;
value pattern : (int list * command) list -> tactic;;
value unfold_nth : (int list * identifier) list -> tactic;;
value clear_hyp : identifier list -> tactic;;
value red_hyp : identifier -> tactic;;
value hnf_tac_hyp : identifier -> tactic;;
value change_hyp : command -> identifier -> tactic;;
value simpl_hyp : identifier -> tactic;;
value unfold_nth_hyp : (int list * identifier) list -> identifier -> tactic;;
value elim : command -> tactic;;
value elim_with : command list -> tactic;;
value elim_last : tactic;;
value elim_type : command -> tactic;;
value induct : identifier -> tactic;;
value induct_nodep : int -> tactic;;
value replace_tac : command -> command -> command -> command -> command -> command -> tactic;;
value equality_tac : command -> command -> command -> command -> command -> tactic;;
value string_head : constr -> string;;
value add_unfold : identifier list -> unit;;
value add_unfold_default : identifier list -> unit;;
value set_add_unfold_fun : (identifier list -> unit) -> unit ;;
value reset_add_unfold_fun : unit -> unit ;;
value add_resolution : identifier list -> unit;;
value add_resolution_default : identifier list -> unit;;
value set_add_resolution_fun : (identifier list -> unit) -> unit ;;
value reset_add_resolution_fun : unit -> unit ;;
value add_rewrite : bool -> identifier list -> unit;;
value add_rewrite_default : bool -> identifier list -> unit;;
value set_add_rewrite_fun : (bool -> identifier list -> unit) -> unit ;;
value reset_add_rewrite_fun : unit -> unit ;;
value erase_tacs : identifier list -> unit;;
value erase_tacs_default : identifier list -> unit;;
value set_erase_tacs_fun : (identifier list -> unit) -> unit;;
value reset_erase_tacs_fun : unit -> unit;;
value erase_tacs_rewrite : bool -> identifier list -> unit;;
value erase_tacs_rewrite_default : bool -> identifier list -> unit;;
value set_erase_tacs_rewrite_fun : (bool -> identifier list -> unit) -> unit;;
value reset_erase_tacs_rewrite_fun : unit -> unit;;
value automatic : int -> tactic;;
value auto : tactic;;
value rewrite_auto : tactic;;
value rewrite_automatic : int->tactic;;
value add_trivial : identifier -> unit;;
value add_trivial_list_default : (identifier list) -> unit;;
value add_trivial_list : (identifier list) -> unit;;
value set_add_trivial_list_fun : ((identifier list) -> unit) -> unit;;
value reset_add_trivial_list_fun : unit -> unit;;
value trivial : tactic;;
value occur_meta : constr -> bool;;
value forme_clausale : int list -> constr -> constr * (int list * constr) list;;
value inst_pf : (int list * constr) list -> prooftree -> prooftree;;
value map_sign : (name * constr) list -> (int list * constr) list -> prooftree list;;
value abstract_list_all : constr -> constr -> constr list -> constr;;
value decomp_app : constr -> constr * constr list;;
value cut_tac : constr -> int list * (name * constr) list * constr -> prooftree;;
value pattern_list : (int list * constr) list -> int list * (name * constr) list * constr -> prooftree;;
value elimination : constr list -> constr -> int list * (name * constr) list * constr -> prooftree;;
value elimination_type : constr -> int list * (name * constr) list * constr -> prooftree;;
value change_pf : constr -> int list * (name * constr) list * constr -> prooftree;;
value refine_type : constr -> int list * (name * constr) list * constr -> prooftree;;
value generalize_tac : constr list -> int list * (name * constr) list * constr -> prooftree;;
value print_state1 : unit -> unit;;
value show_default : unit -> unit;;
value reset_show_fun : unit -> unit;;
value set_print_goal_fun : (int -> unit) -> unit;;
value reset_print_goal_fun : unit -> unit;;
value print_goal_default : int -> unit;;
value set_goal_fun : (unit -> unit) -> unit;;
value reset_goal_fun : unit -> unit;;
value goal_default : unit -> unit;;

