(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                               std.mli                                    *)
(****************************************************************************)

type 'a nref = {mutable v : 'a};;
value nref : 'a -> 'a nref;;
value forward : 'a -> 'b;;
value message : string -> unit;;
value set_message_fun : (string -> unit) -> unit;;
value reset_message_fun : unit -> unit;;
value message_default : string -> unit;;
value o : ('a -> 'b) -> ('c -> 'a) -> 'c -> 'b;;
value length : 'a list -> int;;
value num_of_string : string -> int;;
value string_of_num : int -> string;;
value date : string -> string;;
value succ_int : int -> int;;
value modify_vect : ('a -> 'a) -> 'a vect -> unit;;
value explode : string -> string list;;
value implode : string list -> string;;
value eq_string : string * string -> bool;;
value explode_ascii : string -> int list;;
value item : 'a list -> int -> 'a;;
value tl : 'a list -> 'a list;;
value hd : 'a list -> 'a;;
value null : 'a list -> bool;;
value except_assoc : 'a -> ('a * 'b) list -> ('a * 'b) list;;
value append : 'a list -> 'a list -> 'a list;;
value union : 'a list -> 'a list -> 'a list;;
value index : 'a -> 'a list -> int;;
value curry : ('a * 'b -> 'c) -> 'a -> 'b -> 'c;;
value for_all2 : ('a -> 'b -> bool) -> 'a list -> 'b list -> bool;;
value gt : int * int -> bool;;
value eq : 'a * 'a -> bool;;
exception Identity;;
value share : ('a -> 'a) -> 'a -> 'a;;
value filter : ('a -> bool) -> 'a list -> 'a list;;
value neg : ('a -> bool) -> 'a -> bool;;
value I : 'a -> 'a;;
value C : ('a -> 'b -> 'c) -> 'b -> 'a -> 'c;;
value make_set : 'a list -> 'a list;;
value subtractq : 'a list -> 'a list -> 'a list;;
value distinct : 'a list -> bool;;
value chop_list : int -> 'a list -> 'a list * 'a list;;
value unionq : 'a list -> 'a list -> 'a list;;
value iterate : ('a -> 'a) -> int -> 'a -> 'a;;
value nth : 'a list -> int -> 'a;;
value map : ('a -> 'b) -> 'a list -> 'b list;;
value map_i : (int -> 'a -> 'b) -> int -> 'a list -> 'b list;;
value sort : ('a * 'a -> bool) -> 'a list -> 'a list;;
value ascii_code : string -> int;;
value ascii : int -> string;;
value rev_append : 'a list -> 'a list -> 'a list;;
value it_vect : ('a -> 'b -> 'a) -> 'a -> 'b vect -> 'a;;
value K : 'a -> 'b -> 'a;;
value first_n : int -> 'a list -> 'a list;;
value flat : 'a list list -> 'a list;;
value last : 'a list -> 'a;;
value sep_last : 'a list -> 'a * 'a list;;
value words : string -> string list;;
value scan_string : string -> string -> int -> int;;
value interval : int -> int -> int list;;
value range : int -> int list;;
value add_set : 'a -> 'a list -> 'a list;;
value filter_pos : ('a -> bool) -> 'a list -> 'a list;;
value intersect : 'a list -> 'a list -> 'a list;;
value hash_clear : 'a list vect -> unit;;
value mode_append : int;;
value l_xtnd : int;;
value cocorico : unit -> unit;;
value old_vect_item : 'a vect * int -> 'a;;
value old_vect_assign : 'a vect * int * 'a -> 'a;;
value print_flush : unit -> unit;;
value length_string : string -> int;;
value input_char : in_channel -> char;;
value set_prompt : string -> unit;;
value get_prompt : unit -> string;;
exception break;;
value open_append : string -> out_channel;;
value hash_assoc : 'a -> ('a * 'b) list vect -> 'b;;
value hash_remove_assoc : 'a * 'b -> ('a * 'b) list vect -> unit;;
value hash_add_assoc : 'a * 'b -> ('a * 'b) list vect -> unit;;
value min : int -> int -> int;;
value max : int -> int -> int;;
value repeat : int -> ('a -> 'b) -> 'a -> unit;;
value break_string : string -> string -> string list;;
value skip_string : char list -> string -> string;;
value skip_space_return : string -> string;;
value first_n_string : int -> string -> string;;
value last_n_string : int -> string -> string;;
value fst3 : ('a * 'b * 'c) -> 'a;;
value map_succeed : ('a -> 'b) -> 'a list -> 'b list;;
value make_set : 'a list -> 'a list;;
value caml_assoc : 'a -> ('a * 'b) list -> 'b;;
value Noisy : bool ref;;
value cocorico : unit -> unit;;
