(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             search.mli                                   *)
(****************************************************************************)

#open "initial";;
#open "term";;

type auto_tactic =
  Res_pf of constr
| Give_exact of constr
| Res_pf_THEN_trivial_fail of constr
| Unfold_nth of identifier
| Rewrite_complete of constr
;;

type namedtac == string * (int * auto_tactic);;

value reset_search : unit -> unit;;

type update = New of string | Removed of namedtac;;
type updates == (string * update) list;;

value find_search : string -> namedtac list;;
value insert_search_upd : string -> namedtac -> string * update;;
value insert_search : string -> namedtac -> unit;;
value save_search : unit -> (string * namedtac list) list;;
value restore_search : (string * namedtac list) list -> unit;;
value erase_search : string -> string -> unit;;
value search_tac : string -> unit;;
value SEARCH : (string * namedtac list) list vect;;
value print_search : unit -> unit;;
value print_search_default : unit -> unit;;
value set_print_search_fun : (unit -> unit) -> unit;;
value reset_print_search_fun : unit -> unit;;
value update_search : (string * update) list -> unit;;
value update_list_search : (string * update) list list -> (string * update) list;;
