(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             search.ml                                    *)
(****************************************************************************)

#open "hashtbl";;
#open "std";;
#open "term";;
#open "initial";;
#open "printer";;
#open "more_util";;
#open "pp";;
#open "stdpp";;

(****************************************************************)
(* Essai d'automatisation, on range les tactiques de resolution *)
(*  suivant leur constante de tete et une priorite.         *) 
(****************************************************************)

(* type namedtac == string * (int * tactic);; *)

type searchtable == (string * namedtac list) list vect;;

let length_SEARCH = 211;;

let (SEARCH : searchtable) = make_vect length_SEARCH [];;

let hash_search nh = hash nh mod length_SEARCH;;

let read_search () = SEARCH;;

let reset_search () = hash_clear SEARCH;;

(* Insert a named tactic in a list, following an increasing priority,
   remove a tactic with the same name in the list if such a tactic exists *)

exception Search;;

(* remove the first occurrence of name in list fin and
   gives the list rev_append deb fin' *)

(* type update = New of string | Removed of namedtac;; *)

(* type updates == (string * update) list;; *)

let tac_except name (deb : namedtac list) fin = 
let rec exrec deb = function
        []                 -> raise Search
     | (name',_ as nt)::l -> if name=name' then rev_append deb l,Removed(nt)
                             else exrec (nt::deb) l
in try exrec deb fin with Search -> rev_append  deb fin,New(name);;

(* Insert a named tactic,
   remove a tactic with the same name if already present *)

let insert_namedtac (nt,(pr,_) as ct : namedtac) = insrec_except []
    where rec insrec_except acc  =
    let rec insrec acc = function
             [] -> rev (ct::acc)
           | ((_,(pr',_) as t')::l as l')
            -> if pr <= pr' then rev_append acc (ct::l')
               else insrec (t'::acc) l
    in function []  -> rev (ct::acc), New(nt)
          |  (nt',(pr',_) as t')::l 
            -> if pr <= pr' then
                   if nt=nt' then rev_append acc (ct::l),Removed(t')
                   else tac_except nt (t'::ct::acc) l
               else if nt=nt' then insrec acc l,Removed(t')
                    else insrec_except (t'::acc) l;;

let extract_assoc a = exrec []
    where rec exrec deb = function
          (a',_ as p)::fin -> if a = a' then p, (rev_append deb fin)
                              else exrec (p::deb) fin
       |  _                -> failwith "extract_assoc";;

let find_search name_head =
    let i = hash_search name_head in
    assoc name_head (old_vect_item (SEARCH,i));;

let insert_search_upd name_head (nt,_ as named_tac) =
           let i = hash_search name_head in
    let lnt = old_vect_item (SEARCH,i) in
    let newlnt,newup = try
                 let ((nh,lnamedtac),rest) = extract_assoc name_head lnt
                 in let (lnt',up') = insert_namedtac named_tac lnamedtac
                    in (nh,lnt')::rest,(nh,up')
                 with Failure _ -> (name_head,[named_tac])::lnt,
                                   (name_head,New(nt))
    in old_vect_assign (SEARCH,i,newlnt);newup;;

let insert_search name_head named_tac
    = insert_search_upd name_head named_tac;();;


let save_search () = it_vect (fun l ltac -> ltac@l) [] SEARCH;;

let restore_search l = reset_search ();
    do_list (function (nh,_ as to_ins) -> 
             let i = hash_search nh in
             old_vect_assign(SEARCH,i,to_ins::(old_vect_item (SEARCH,i)))) l;;

(* raise Failure if name_head does not appear in SEARCH *)
let erase_search_fail name_head nt =
    let i = hash name_head mod length_SEARCH in
    let lnt = old_vect_item (SEARCH,i) in
    let ((nh,lnamedtac),rest) = extract_assoc name_head lnt
    in let newnt,_ = tac_except nt [] lnamedtac
    in let newlnh = if newnt = [] then rest else (nh,newnt)::rest
    in old_vect_assign (SEARCH,i,newlnh);();;

let erase_search name_head nt =
    try erase_search_fail name_head nt
    with Failure _ -> error ("no tactics saved for "^(name_head));;

let search_tac nametac =
    do_vect (do_list (function (nhd,(lhd : namedtac list)) ->
                       if mem_assoc nametac lhd
                       then message ("tactic : "^nametac^" saved for head : "^
                                  nhd))) SEARCH;;

let print_search_default () = do_vect print_namedtac_list SEARCH
    where print_namedtac_list = do_list print_namedtac
    where print_namedtac = function
     (name_head,ntlist) -> PPNL [< prs ("For "^name_head^" -> ");
                            prlist (function (name_tac,(pr,_))->
                                    [< prs (name_tac^",");'INT pr;
                                     prs" " >]) ntlist >];;

let PRINT_SEARCH_FN = ref [print_search_default];;

let print_search () = (hd !PRINT_SEARCH_FN)();;

let set_print_search_fun f = PRINT_SEARCH_FN := f::!PRINT_SEARCH_FN;();;

let reset_print_search_fun () = PRINT_SEARCH_FN := tl !PRINT_SEARCH_FN;();;

let update_tac = function
     name_head, (New nt)    -> (try erase_search_fail name_head nt
                                with Failure _ -> ())
   | name_head, Removed(nt) -> insert_search name_head nt;;

let update_search = do_list update_tac;;

let update_list_search =
   function [] -> []
          | lt::llt -> do_list update_search (rev llt);lt;;
