#open "initial";;
#open "extraction";;
#open "termfw";;
#open "term";;
#open "command";;
#open "tactics";;

type annote =
    Avar of name * fterm                  (* free variables *)
  | Aconst of name * fterm                (* constants *)
  | Arel of int                           (* variables *)
  | Aomega                                (* proposition types *)
  | Aapp of annote * annote               (* application  (M N) *)
  | Alambda of name * fterm * annote      (* abstraction  [x:T]M *)
  | Alambdacom of name * constr * annote
  | Aprod of name * fterm * fterm         (* product      (x:T)M *)
  | Aind of name * fterm * fterm list * fspecifr * fterm list
  | Aconstr of int * fterm
  | Arec of fterm * annote list * annote
  | Arecursion of fterm * fterm * fterm * constr
  | Annot of annote * constr
  | Aimplicit ;;

type annoted_command = 
    AappC of annoted_command * annoted_command                 
  | AlambdaC of identifier * command * annoted_command  
  | AlambdacomC of identifier * command * annoted_command     
  | ArecC of annoted_command * command 
  | ArecursionC of command * command * command * command
  | AnnotC of annoted_command * command
  | ApurC of command
;;

exception NONPUR of string ;;
exception NONTRIVIAL of string ;;
exception NONSPECIF ;;

value caml_assoc_sign : identifier -> (name * 'a) list -> 'a;;
value contents_level_of_arity : constr -> contents * level;;
value fsign_of_sign : ('a * constr) list -> ('a * fterm) list;;
value fterm_of_com : (name * fterm) list -> command -> fterm;;
value info_of_constr : constr -> information;;
value info_of_constr_rel : (constr * contents * level) list -> constr -> information;;
value info_of_constr_meta : (int list * information) list -> constr -> information;;
value is_logic : information -> bool;;
value fterm_of_com_use : (name * constr) list -> command -> fterm;;
value nb_red_intro : int -> int -> int list * (name * constr) list * constr -> constr -> int * int;;
value DOTHEN : int -> (int list * (name * constr) list * constr -> prooftree) -> (int list * (name * constr) list * constr -> prooftree) -> int list * (name * constr) list * constr -> prooftree;;
value find_ind : constr -> constr;;
value constr_of_fterm : 'a * (name * constr) list * constr -> fterm -> constr;;
value constr_of_pure_fterm : (name * constr) list -> fterm -> constr;;
value constr_of_pure_fterml : constr list -> (name * constr) list -> fterm -> constr;;
value fterm_of : information -> fterm;;
value list_arg : fterm -> fterm * fterm list;;
value fred_all : fterm -> fterm;;
value red_all_lie : constr -> bool * constr;;
value red_all : constr -> constr;;
value is_logical : (int list * constr) list -> constr -> bool;;
value try_matching : (int list * constr) list -> constr -> constr -> (int list * constr) list;;
value go_to_info : int -> (int list * information) list -> constr -> constr * int * (int list * information) list;;
value dependant : constr -> constr -> bool;;
value nb_intros_liees_list : constr list -> constr -> int;;
value nb_intros_liees : constr -> constr -> int;;
value nb_intros : constr -> int;;
value annot_of_fterm : fterm -> annote;;
value fterm_of_annot : annote -> fterm;;
value asubst_var : name -> annote -> annote;;
value aapplist : annote -> annote list -> annote;;
value aclosed : annote -> bool;;
value is_annot : annote -> bool;;
value asubst1 : annote -> annote -> annote;;
value asubstconstr1 : constr -> annote -> annote;;
value aconv : annote -> annote -> bool;;
value atype_of : annote -> annote;;
value amake_elimination : annote -> annote -> annote;;
value amake_elimination_rel : annote list -> annote -> annote -> annote;;
value ared_elimination : fterm * annote list * annote -> annote;;
value anf : annote -> annote;;
value areduce : annote -> annote * annote list;;
value fconv2 : fterm -> fterm -> bool;;
value aconv2 : annote -> annote -> bool;;
value atype_constr : annote list -> annote -> annote;;
value fterm_of_ident : constr -> fterm;;
value forget_annot : annoted_command -> command;;
value extract : (constr * contents * level) list -> (int list * information) list -> constr -> information * level;;
value find_ainductype : annote -> (name * fterm * fterm list * fspecifr * fterm list) * annote list;;
value alift : int -> annote -> annote;;
value atype_of2 : annote -> annote;;
value asubst2 : annote -> constr -> annote -> annote;;
value areduce_app : annote -> annote * annote list;;
value remove_annote : annote -> annote;;
value amake_elimination2 : annote -> annote -> annote;;
