(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                            printer.mli                                   *)
(****************************************************************************)
#open "more_util";;
#open "term";;
#open "termfw";;
#open "initial";;
#open "pp";;
#open "stdpp";;

value line : unit -> std_ppcmds;;
value pri : int -> std_ppcmds;;
value prs : string -> std_ppcmds;;
value let_syntax : identifier -> string -> string;;
value prterm : constr -> std_ppcmds;;
value pr : constr -> std_ppcmds;;
value fprterm : fterm -> std_ppcmds;;
value print_decl : name * constr -> std_ppcmds;;
value pr_subgoals : ('a * (name * constr) list * constr) list -> std_ppcmds;;
value pr_subgoal : int -> ('a * (name * constr) list * constr) list -> std_ppcmds;;

type syntax_table == (identifier * string list) list;;
value read_syntax : unit -> syntax_table;;
value reset_syntax : syntax_table -> unit;;
value print_table : identifier -> string list;;
value fterm0 : identifier option list -> fterm -> std_ppcmds;;
value term0 : identifier option list -> constr -> std_ppcmds;;
value fdependent : fterm -> bool;;
value print_nth_env : identifier option list -> int -> std_ppcmds;;
value pr_stamp : name -> std_ppcmds;;
