(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             printer.ml                                   *)
(****************************************************************************)
#open "std";;
#open "univ";;
#open "initial";;
#open "extraction";;
#open "initial";;
#open "term";;
#open "termfw";;
#open "pp";;
#open "stdpp";;
#open "more_util";;

let prs s = [< 'S s >]
and pri n = [< 'INT n >]
and line() = [< 'FNL >];;

let SYNTAX = ref ([] : syntax_table);;

let print_table id = try caml_assoc id !SYNTAX
                      with Failure _ -> [string_of_id id];;

let breaking sep string =
 let scan (strs,chars) char =
  if char = sep then implode chars::strs,[] else strs,char::chars in
  fst (it_list scan ([],[]) (rev (sep::explode string)));;

let break_underscore = breaking "_";;

let let_syntax name pattern =
 SYNTAX := (name,break_underscore pattern)::!SYNTAX;
 "syntax of "^(string_of_id name)^" defined";;

let la_date () =
 match breaking "|" (date "|") with
    [day; month; year] ->
      let d = string_of_num (num_of_string day)
      
      and m =
       match month with
          "01" -> " Janvier 19"
        | "02" -> " Fevrier 19"
        | "03" -> " Mars 19"
        | "04" -> " Avril 19"
        | "05" -> " Mai 19"
        | "06" -> " Juin 19"
        | "07" -> " Juillet 19"
        | "08" -> " Aout 19"
        | "09" -> " Septembre 19"
        | "10" -> " Octobre 19"
        | "11" -> " Novembre 19"
        | "12" -> " Decembre 19"
        | _ -> anomaly "la_date" in
       d^m^year
  | _ -> anomaly "la_date";;

let new_str s c env = next_ident_away s (globals c @ (genterm__drop env))
and new_na n c env = next_name_away n (globals c @ (genterm__drop env));;

let print_nth_env env n =
    match nth env n with
    NONE -> [< >]
  | (SOME id) -> print_id id
;;

let is_exist l id = match string_of_id id with
    "sig"|"sigS" -> length l = 2
  | "sig2"|"sigS2" -> length l = 3
  | _ -> false;;

let rec is_ident c =
 match c with
    Const (Def (Name str,_,_)) -> mem_assoc str !SYNTAX
  | App (c,c') -> is_ident c
  | _ -> false;;

let eta_expand t c env = match c with
    Lambda (n,t',c) -> let n' = new_na n c env in Lambda (Name n',t',c)
  | c -> let n = new_str (id_of_string "X") c env in Lambda (Name n,t,App (lift 1 c,Rel 1));;

let pr_stamp = function
    (Name id) -> [< 'S"[" ; print_id id ; 'S"]" >]
  | (Anonymous) -> [< >]
;;

let rec term0 env = function
    Const(Def(Name str,_,_)) ->
    (match print_table str with
     [str']-> [< 'S str' >]
   | _    -> print_id str)

  | Var(Decl(Name(str),_,_))  -> [< print_id str >]

  | (Ind(stamp,c,l,_,_) as i)       ->
    HOV 0
    [< 'S "Ind" ; pr_stamp stamp ; 'S"("; 'CUT ;
       (let X = new_str (id_of_string "X") i env in
           [< print_id X; 'S ":"; 'CUT; term0 env c; 'S")"; 'CUT;
              'S"{";
              HOV 0
              [< prlist_with_sep (fun () -> [< 'S "|" >])
                                 (term0 ((SOME X)::env)) l >]
           >]);
       'CUT ; 'S"}" >]

  | Rec(b,P::lf,c)          ->
    HOV 0
    [< HOV 0
       [< 'S"(<"; term0 env P; 'S">" >]; 'BRK(0,2);
       HOV 0
       [< 'S"Match";'SPC;
        term0 env c;'SPC; 'S"with" >]; 'BRK(1,3); 
       HOV 0
       [< prlist (fun t ->
                 HOV 0 [< HOV 0 [< term0 env t >]; 'FNL >]) lf;
          'S")" >]
    >]

  | Construct(i,c)          ->
    HOV 0 [< 'S"Constr("; 'INT i; 'S",";'CUT;
           term0 env c;'S")" >]

  | Rel(n)                  ->
    if (length env >= n) & (n>0) then
        [< print_nth_env env n >]
    else
        H 0 [< 'S"Rel(";'INT n;'S")" >]

  | Meta(n)                 ->
    [< 'S"Meta("; 'INT (hd n); 'S")" >]

  | Prop(Null)          ->
    [< 'S "Prop" >]

  | Prop(Pos)               ->
    [< 'S "Set" >]

  | Prop(Data)              ->
    [< 'S "Data" >]

  | Type(Null,_)            ->
    [< 'S "Type" >]

  | Type(Pos,_)             ->
    [< 'S "Type_Set" >]

  | Type(Data,_)            ->
    [< 'S "Type_Data" >]

  | Lambda(n,t,c)           ->
    HOV 0
    [< 'S"[";
       let s = new_na n c env in
           [< print_id s;'S":"; term0 env t;'S"]";'BRK(0,1);
            term1 ((SOME s)::env) c >]
    >]

  | Prod(n,t,t')            ->
    if dependent 1 t' then 
        HOV 0
        [< 'S"(";
         let s = new_na n t' env in
             [< print_id s;'S":"; term0 env t;'S")";'BRK(0,1);
              term1' ((SOME s)::env) t' >]
        >]
    else
        HOV 0
        [< termarr env t; 'CUT;'S"->";'BRK(0,1);
         term1' (NONE::env) t' >]

  | App(c,c')               ->
    termapp0 env (c,[c'])

  | Implicit                -> [< 'S "." >]

  | _                       -> anomaly "Not printable"

and term1 env = function
    App(c,c')     ->  termapp1 env (c,[c'])
  |  x     -> term0 env x

and term1' env = function
    App(c,c')     ->
    if (is_ident c) then
        HOV 0 [< 'S"("; termapp1 env (c,[c']); 'S")" >]
    else
        termapp1 env (c,[c'])
  |  x     -> term0 env x

and termarr env = function
    (Prod(_) as t)           ->
    HOV 0 [< 'S"("; term0 env t; 'S ")" >]
  | x                        -> HOV 0 [< term1' env x >]

and termapp1 env = function t -> termapp0 env t

and termapp0 env = function
    App(c,c'),l                -> termapp0 env (c,(c'::l))
  | Const(Def(Name(str),_,_)),l  ->
    if is_exist l str then
        print_exist env (str,l)
    else
        let m = print_table str in
            [< if (length l)+1 = length m
                   then HOV 0 [< ptable env (m,l) >]
               else
                   HOV 0 [< 'S"("; print_id str; 
                            prlist (fun t -> [< 'BRK(1,3); term0 env t>]) l;'S")" >]
            >]

 | x,l                        ->
   HOV 0 [< 'S"("; term0 env x;
            prlist (fun t -> [< 'BRK(1,3); term0 env t >]) l; 'S")" >]

and print_exist env = function
   str,[t;c] ->
   HOV 0 [< 'S"{";
            (let (Lambda(Name s,t',c')) = eta_expand t c env in
                [< print_id s;'S":"; term0 env t';
                 'if (string_of_id str) = "sig" then S "|" else S "&"; 'BRK(0,1);
                 term0 ((SOME s)::env) c'
                >]);
                'S"}"
         >]

 | str,[t;c1;c2] ->
   HOV 0 [< 'S"{";  
          (let (Lambda(Name s,t',c1')) = eta_expand t c1 env
          and (Lambda(_,_,c2')) = eta_expand t c2 env in
              [< print_id s;'S":"; term0 env t';
               'if (string_of_id str) = "sig2" then S"|" else S"&"; 'BRK(0,1);
               term0 ((SOME s)::env) c1';'S"&"; term0 ((SOME s)::env) c2'
              >]);
              'S"}"
         >]

 | _             -> anomaly "should be an existential"

and Identx = function "" -> [< >]
                 | x  -> [< 'S x >]

and ptable env = function
    [str],[] -> Identx str

  | (""::m,(Prod(_) as b)::l) ->
    HOV 0
    [< 'S"("; term1 env b; 'S")"; 'CUT; ptable env (m,l) >]

  | (""::m,(App(_) as b)::l) ->
    HOV 0
    [< (if (is_ident b) then
           HOV 0 [< 'S"("; term1 env b; 'S")" >]
       else term1 env b) ;
           'CUT; ptable env (m,l) >]

  | (""::m,b::l) ->
    HOV 0 [< term1 env b; 'CUT; ptable env (m,l) >]

  | (a::m,(Prod(_) as b)::l) ->
    HOV 0 [< 'S a; 'S"("; term0 env b; 'S")";
             'CUT;ptable env (m,l) >]  

  | (a::m,(App(_) as b)::l) ->
    HOV 0 [< 'S a;
             (if (is_ident b) 
                 then HOV 0 [< 'S"("; term0 env b; 'S")" >]
             else term0 env b);
             'CUT;ptable env (m,l) >] 

  | (a::m,b::l) ->  HOV 0 [< 'S a;term0 env b; 'CUT;ptable env (m,l) >]

  | _           ->  anomaly "ptable";;

let prterm = term0 [];;

let pr t = [< prterm t; 'FNL >];;

let fdependent =
 let rec deprec k = function
     Frel n -> n = k
   | Fapp (c,c') -> deprec k c or deprec k c'
   | Flambda (_,c,c') -> deprec k c or deprec (k+1) c'
   | Fprod (_,c,c') -> deprec k c or deprec (k+1) c'
   | Find (_,c,l,_,_) -> deprec k c or exists (deprec (k+1)) l
   | Fconst (_,c) -> deprec k c
   | Frec (l,c) -> exists (deprec k) l or deprec k c
   | _ -> false in
  deprec 1;;

let fnew_str s c env = next_ident_away s (fglobals c@ (genterm__drop env))
and fnew_na n c env = next_name_away n (fglobals c@ (genterm__drop env));;

let rec fterm0 env = function
    Fconst(Name(str),_) ->
    (match print_table str with
         [str'] -> [< 'S str' >]
       | _      -> print_id str)

  | Fvar(Name(str),_)    -> [< print_id str >]

  | (Find(stamp,c,l,_,_) as i)   ->
    HOV 0 [< 'S"Ind" ; pr_stamp stamp ; 'S"(";'CUT;
           (let X = fnew_str (id_of_string "X") i env in
                [< print_id X;'S":";'CUT; fterm0 env c;'S")";'CUT;
                 'S"{";
                 HOV 0
                 [< prlist_with_sep (fun () -> [< 'S "|" >])
                                     (fterm0 ((SOME X)::env)) l >]
               >]);
           'CUT;'S"}"
          >]

  | Frec(P::lf,c)        ->
    HOV 0 [< 'S"(<"; fterm0 env P; 'S">Match"; 'SPC;
             fterm0 env c; 'SPC; 'S"with";
             HOV 0
             [< prlist (fun t -> [< 'SPC;fterm0 env t >]) lf;'S")">]
          >]

  | Fconstr(i   ,c)      ->
    HOV 0
    [< 'S"Constr("; 'INT i; 'S",";'CUT;
       fterm0 env c;'S")" >]

  | Frel(n)              ->
    if length env >= n then
        [< print_nth_env env n >]
    else
        H 0 [< 'S"Rel(";'INT n;'S")" >]

  | Fomega               -> [< 'S"Data" >]

  | Fapp(c,c')           -> ftermapp env (c,[c'])

  | Flambda(n,t,c)       -> 
   HOV 0 [< 'S"[";
            (let s = fnew_na n c env in
                 [< print_id s;'S":"; fterm0 env t;'S"]";'BRK(0,1);
                  fterm0 ((SOME s)::env) c >])
         >]

  | Fprod(n,t,t')        ->
    if fdependent t' then
        HOV 0 [< 'S"(";
               (let s = fnew_na n t' env in
                    [< print_id s;'S":"; fterm0 env t;'S")";'BRK(0,1);
                     fterm0 ((SOME s)::env) t' >])
              >]
    else
        HOV 0 [< ftermarr env t;'CUT;'S"->";'BRK(0,1);
               fterm0 (NONE::env) t' >]
  | Fimplicit            -> [< 'S"." >]

and ftermarr env = function
    (Fprod(_) as t)      -> HOV 0 [< 'S"("; fterm0 env t; 'S")" >]
  | x                    -> fterm0 env x

and ftermapp env = function
    Fapp(c,c'),l         -> ftermapp env (c,(c'::l))
  | Fconst(Name(str),_),l-> 
    let m = print_table str in
        if (length l)+1 = length m then
            HOV 0 [< 'S"("; fptable env (m,l);'S")" >]
        else
            HOV 0 [< 'S"("; print_id str;
                     prlist (fun t -> [< 'BRK(1,3); fterm0 env t >]) l;
                     'S")" >]

 | x,l                   ->
   HOV 0 [< 'S"("; fterm0 env x;
            prlist (fun t -> [< 'BRK(1,3); fterm0 env t >]) l;
            'S")" >]

and Identx = function "" -> [< >]
                 | x  -> [< 'S x >]

and fptable env = function
  [str],[]       ->  Identx str
| (a::m,b::l)    ->
  HOV 0 [< Identx a;'CUT;fterm0 env b;'CUT;fptable env (m,l) >]
| _              ->  anomaly "ptable";;

let fprterm = fterm0 [];;

let prt c = [< 'S "  "; prterm c >];;

let print_decl (Name s,v) = [< print_id s ; prs " : ";prterm (type_of v) >];;

let pr_goal (_,sign,c) = 
 let pr_sign = function
     [] -> [< >]
   | l -> [< 'CUT; prs "============================";
             'CUT; prs "  ";
             V 0 [< pr_rec l >] >]
 where rec pr_rec = function
 [] -> [< >]
  |  [u]     -> print_decl u
  |  u::rest -> [< print_decl u; 'CUT; pr_rec rest >]

 in V 2 [< prt c; pr_sign sign >];;

let pr_concl n (_,_,c) =
 [< prs "subgoal ";pri n;prs " is:";'CUT;prt c >];;

let pr_subgoals = function
    [] -> cocorico (); prs "Goal proved!"
  | [g] ->
      V 0 [< prs ("1 "^"subgoal");'CUT;pr_goal g >]

  | g1::rest ->
      let rec pr_rec n = function
          [] -> [< >]
        | g::rest -> [< 'CUT;pr_concl n g;pr_rec (n+1) rest >] in
       V 0
       [< prs (string_of_int (length rest+1)^" subgoals");'CUT;
       pr_goal g1;pr_rec 2 rest >];;

let pr_subgoal n =
 let rec prrec p = function
     [] -> error "No such goal"
   | g::rest ->
       if p = 1
        then V 0
            [< prs "subgoal ";pri n;prs " is:";'CUT;pr_goal g >]
        else prrec (p-1) rest in
  prrec n;;

let read_syntax() = !SYNTAX;;
let reset_syntax s = SYNTAX := s; ();;
forward_prterm.v <- prterm;;
