(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                          print_program.ml                                *)
(****************************************************************************)
#open "std";;
#open "initial";;
#open "univ";;
#open "termfw";;
#open "term";;
#open "printer";;
#open "program";;
#open "pp";;
#open "stdpp";;
#open "more_util";;

let fnew_str s c env = next_ident_away s (fglobals c @ (genterm__drop env))
and fnew_na n c env = next_name_away n (fglobals c @ (genterm__drop env));;

let print_nth_env env n =
    match nth env n with
    NONE -> [< >]
  | (SOME id) -> print_id id
;;

let add_bound s env = (s::env);;

let globalsl l c =
 let rec glob_rec globs = function
     Var (Decl (Name s,_,_)) -> s::globs
   | Const (Def (Name s,_,_)) -> s::globs
   | App (c,c') -> glob_rec (glob_rec globs c') c
   | Lambda (_,c,c') -> glob_rec (glob_rec globs c) c'
   | Prod (_,c,c') -> glob_rec (glob_rec globs c) c'
   | Ind (_,c,l,_,_) -> it_list glob_rec (glob_rec globs c) l
   | Construct (_,c) -> glob_rec globs c
   | Rec (_,f,c) -> it_list glob_rec (glob_rec globs c) f
   | _ -> globs in
  make_set (glob_rec l c);;

let fglobalsl l c =
 let rec glob_rec globs = function
     Fvar (Name s,_) -> s::globs
   | Fconst (Name s,_) -> s::globs
   | Fapp (c,c') -> glob_rec (glob_rec globs c') c
   | Flambda (_,c,c') -> glob_rec (glob_rec globs c') c
   | Fprod (_,c,c') -> glob_rec (glob_rec globs c') c
   | Find (_,c,l,_,_) -> it_list glob_rec (glob_rec globs c) l
   | Fconstr (_,c) -> glob_rec globs c
   | Frec (l,c) -> it_list glob_rec (glob_rec globs c) l
   | _ -> globs in
  make_set (glob_rec l c);;

let aglobals c =
 let rec glob_rec globs = function
     Avar (Name s,_) -> s::globs
   | Aconst (Name s,_) -> s::globs
   | Aapp (c,c') -> glob_rec (glob_rec globs c') c
   | Alambda (_,c,c') -> fglobalsl (glob_rec globs c') c
   | Alambdacom (_,c,c') -> globalsl (glob_rec globs c') c
   | Aprod (_,c,c') -> fglobalsl (fglobalsl globs c') c
   | Aind (_,c,l,_,_) -> it_list fglobalsl (fglobalsl globs c) l
   | Aconstr (_,c) -> fglobalsl globs c
   | Arec (P,l,c) ->
       it_list glob_rec (glob_rec globs c) (annot_of_fterm P::l)
   | Arecursion (wf,A,P,R) -> fglobalsl (globalsl globs R) wf
   | Annot (c,P) -> glob_rec (globalsl globs P) c
   | _ -> globs in
  make_set (glob_rec [] c);;

let anew_str s c env = next_ident_away s (aglobals c@ (genterm__drop env))
and anew_na n c env = next_name_away n (aglobals c@ (genterm__drop env));;

let pr_stamp = function
    (Name id) -> [< 'S"[" ; print_id id ; 'S"]" >]
  | (Anonymous) -> [< >]
;;

let rec annote0 (env:identifier option list) = function
    Aconst(Name(str),_)  ->
    (match print_table str with
     [str'] -> [< 'S str' >]
   | _      -> print_id str)

  | Avar(Name(str),_)    -> [< print_id str >]
  | (Aind(stamp,c,l,_,_) as i)   ->
    HOV 0
    [< 'S"Ind" ; pr_stamp stamp ; 'S"(";'CUT;
     (let X = anew_str (id_of_string "X") i env in
          [< print_id X;'S":";'CUT; fterm0 env c;'S")";'CUT;
           'S"{";
           prlist_with_sep (fun () -> [< 'S "|" >]) (fterm0 ((SOME X)::env)) l
           >]);
     'CUT;'S"}">]

  | Arec(P,[Alambda(n,t,f)],c) ->
    HOV 0
    [< 'S"<"; fterm0 env P; 'S">";
     V 0 [< 'S"Let ";
          HOV 0 [< 'S"(";
                 (let s = anew_na n c env in
                      [< print_id s;'S":"; fterm0 env t;'BRK(0,1);
                       abstractp ((SOME s)::env) f;
                       'S" ="; 'S" "; annote0 env c;
                        'CUT; 'S" in "; constantp ((SOME s)::env) f >])
                      >]
          >]
     >]

  | Arec(P,lf,c)         ->
    HOV 0 [< 'S"(<"; fterm0 env P; 'S">";
           V 0 [< 'S"Match"; 'S" ";
                annote0 env c;'S " "; 'S"with"; 'CUT;
                prlist (function t -> [< annote0 env t;'CUT >]) lf;
                'S")" >]
           >]

  | Aconstr(i,c)         ->
    HOV 0
    [< 'S"Constr("; 'INT i; 'S",";
     'CUT; fterm0 env c;'S")" >]

  | Arel(n)              ->
    if length env >= n then
        [< print_nth_env env n >]
    else H 0 [< 'S"Rel(";'INT n;'S")" >]

  | Aomega               -> [< 'S "Data" >]

  | Arecursion(wf,A,P,R) ->
    HOV 0 [< 'S"(<"; fterm0 env P ; 'S">"; 'S"rec";
             'CUT; 'S " "; 'S"(: "; 'CUT; term0 env R; 'S " "; 'S":)" >]

(*  | Arecursion(wf,A,P,R) ->
    HOV 0 [< fterm0 env wf;
           prlist (fun t -> [< 'BRK(1,3); fterm0 env t >]) (A::[P]);'CUT;
           'S"(:"; 'CUT; term0 env R; 'S " "; 'S":)" >]*)
 
  | Aapp(c,c')           ->  annoteapp env (c,[c'])

  | Alambda(n,t,c)       ->
    HOV 0 [< 'S"[";
           (let s = anew_na n c env in
                [< print_id s;'S":"; fterm0 env t;'S"]";'BRK(0,1);
                 annote0 ((SOME s)::env) c >]) >]

  | Alambdacom(n,t,c)    ->
    HOV 0 [< 'S"[{";
           (let s = anew_na n c env in
                [< print_id s;'S":"; term0 env t;'S"}]";'BRK(0,1);
                 annote0 ((SOME s)::env) c >]) >]

  | Annot(c,P)           ->
    HOV 0 [< annote0 env c;'S" "; 'S"(:"; term0 env P; 'S":)" >]
  | Aprod(n,t,t')        ->
    if fdependent t' then
        HOV 0 [< 'S"(";
               (let s = fnew_na n t' env in
                    [< print_id s;'S":"; fterm0 env t;'S")";'BRK(0,1);
                     fterm0 ((SOME s)::env) t' >] ) >]
    else HOV 0 [< ftermarr env t;'CUT;'S"->";'BRK(0,1);
                fterm0 env t' >]
  | Aimplicit             -> [< 'S"." >]

and ftermarr env = function
    (Fprod(_) as t)      ->
    HOV 0 [< 'S"("; fterm0 env t; 'S")" >]
  | x                    -> fterm0 env x

and annoteapp env = function
    Aapp(c,c'),l         -> annoteapp env (c,(c'::l))
  | Aconst(Name(str),_),l->
    let m = print_table str in
        if (length l)+1 = length m then
            HOV 0 [< 'S"("; aptable env (m,l);'S")" >]
        else
           HOV 0 [< 'S"("; print_id str;
                  prlist (fun t -> [< 'BRK(1,3); annote0 env t >]) l;
                  'S")" >]

 | x,l                   ->
   HOV 0 [< 'S"("; annote0 env x;
          prlist (fun t -> [< 'BRK(1,3); annote0 env t >]) l; 'S")" >]

and Identx = function "" -> [< >]
                 | x  -> [< 'S x >]

and aptable env = function
  [str],[]       ->  Identx str
| (a::m,b::l)    ->
  HOV 0 [< Identx a;'CUT;annote0 env b;'CUT;aptable env (m,l) >]
| _              ->  anomaly "aptable"

and abstractp env = function
  Alambda(n,t,f) ->
  HOV 0 [< 'S";"; 
         (let s = anew_na n f env in
              [< print_id s;'S":"; fterm0 env t;'BRK(0,1);
               abstractp ((SOME s)::env) f >]) >]

| f              -> [< 'S ")" >]

and constantp env = function
  Alambda(n,t,f) ->
  HOV 0 [< (let s = anew_na n f env in 
                constantp ((SOME s)::env) f) >]

| f              -> [< 'CUT; annote0 env f >]
;;

let aprterm = (fun x -> PPNL(annote0 [] x));;
