(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             machine.mli                                  *)
(****************************************************************************)

#open "initial";;
#open "term";;
#open "extraction";;
#open "univ";;
#open "search";;

(* Strength of constants *)

type strength = Strength of int ;;

(* Declarations *)
type declaration =  Vardecl of variable * strength * updates
                  | Constdecl of constant * strength * updates
                  | Value of judgement * information
                  | Cast of judgement * information
                  | Scope of strength
                  | Section of string
                  | Loaded of string list;;

type context == (declaration * universes) list;;

value read_inf : unit -> information;;
value read_val : unit -> constr;;
value read_sec : unit -> int;;
value read_var : unit -> declaration list;;
value read_context : unit -> (declaration * universes) list;;
value read_state : unit -> (declaration * universes) list * constr * constr * level * information;;
value add_tac_search : string -> namedtac -> unit;;

exception Undeclared;;

value exists_var : identifier -> bool;;
value search : identifier -> declaration;;
value new_name : identifier -> identifier;;
value new_namel : identifier -> identifier list -> identifier;;
value assume : identifier -> int -> unit;;
value assume_cast : name -> int -> unit;;
value postulate : int -> unit;;
value declare : identifier -> int -> unit;;
value stack_value : unit -> unit;;
value stack_cast : unit -> unit;;
value push_scope : strength -> unit;;
value pop_scope : unit -> strength;;
value global : identifier -> constr;;
value consider : identifier -> unit;;
value typof : identifier -> constr;;
value valof : identifier -> constr;;
value proposition : contents -> unit;;
value new_type : contents -> unit;;
value pop_apply : unit -> unit;;
value pop_const : unit -> unit;;
value abs_var : unit -> unit;;
value gen_var : unit -> unit;;
value reset_cast : unit -> unit;;
value reset_keeping_cast : unit -> unit;;
value verify : unit -> unit;;
value open_section : string -> unit;;
value current_section : unit -> string;;
value close_section : string -> bool -> unit;;
value close_section' : string -> bool -> unit;;
value raw_reset_keeping_name : identifier -> unit;;
value raw_reset_name : identifier -> unit;;
value raw_reset_section : string -> unit;;
value raw_save_state : string -> string -> unit;;
value raw_restore_state : string -> unit;;
value forget_state : bool -> string -> unit;;
value list_saved_states : unit -> (string * string) list;;
value save_light : unit -> unit;;
value forget_light : unit -> unit;;
value restore_light : unit -> unit;;
value raw_reset_all : unit -> unit;;
value extern_state : string -> unit;;
value intern_state : string -> unit;;
value chop_context : identifier -> (declaration * universes) list -> (declaration * universes) list * (declaration * universes) list;;
value inductype : name -> int -> unit;;
value constructor : int -> unit;;
value execute : constr -> unit;;
value creation_var : name -> constr -> constr;;
value val_of : identifier -> constr;;
value dep_elimination : constr -> constr list -> unit;;
value nodep_elimination : constr -> unit;;
value elimination : unit -> unit;;
value recursive : name -> bool -> int -> strength -> unit;;
value search_cast : unit -> judgement * (declaration * universes) list * (declaration * universes) list;;
value search_packages : unit -> string list;;
value declare_package : string -> unit;;
value add_path : string -> unit;;
value del_path : string -> unit;;
value search_paths : unit -> string list;;
