(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             listset.ml                                   *)
(****************************************************************************)
#open "std";;
#open "more_util";;

let add fs a = if mem a fs then fs else (a::fs)
;;
let rec rmv = fun
    (h::t) a -> if h = a then t else h::(rmv t a)
  | _ _ -> failwith "listset__rmv"
;;
let memb ls a = mem a ls
;;
let choose P fs = hd(filter P fs)
;;
let intersect l1 l2 = filter (fun x -> mem x l2) l1
;;
let union fs1 fs2 = uniquize(fs1@fs2)
;;
let diff l1 l2 = filter (fun x -> not (mem x l2)) l1
;;
let symdiff l1 l2 = diff(union l1 l2) (intersect l1 l2)
;;
let subset l1 l2 = for_all (memb l2) l1
;;
let equal s1 s2 = subset s1 s2 & subset s2 s1
;;
