(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             listmap.ml                                   *)
(****************************************************************************)
#open "std";;
#open "more_util";;

let rec delete n (((a,b) as h)::t) =
    if n = a then
        t
    else
        ((a,b)::(delete n t));;

let new() = [];;
let map l a = assoc a l;;

let dom l = list__map fst l;;

let rng l = list__map snd l;;

let in_dom l a = in_dom_a l where rec in_dom_a = function
    [] -> false
  | ((a',_)::l) -> (a = a') or in_dom_a l
;;

let in_rng l b = in_rng_b l where rec in_rng_b = function
    [] -> false
  | ((_,b')::l) -> (b = b') or in_rng_b l;;

let inv l b = list__map fst (filter (fun (a',b') -> b' = b) l);;

let add l (a,b) =
    if in_dom l a then
        raise (Failure "listmap__add")
    else ((a,b)::l);;

let rmv l a =
    if in_dom l a then
        delete a l
    else raise Not_found;;

let remap l a b =
let rec aux = function
    ((k,v)::t) ->
    if k = a then (a,b)::t
    else (k,v)::(aux t)
  | _ -> failwith "listmap__remap"
in
    aux l;;

let app f l = do_list f l;;

let toList l = l;;
