(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             lexer.mli                                    *)
(****************************************************************************)

type 'a token =
  Tampersand | Tbar | Tbslashslash | Tcolon | Tcolonequal | Tcomma | Tdot | Tequal | Tequalequal | Tgreater | Tident of string | Tint of int | Tkw of 'a | Tlbrace | Tlbracket | Tless | Tlessminus | Tlessminusgreater | Tlparen | Tminus | Tminusgreater | Tplus | Trbrace | Trbracket | Trparen | Tsemi | Tsemisemi | Tsharp | Tslash | Tslashbslash | Tstar | Tstring of string | Ttilde
  | Tlparencolon | Tlbracketlbrace
;;

value token_stream :
  (string * 'a) list vect -> char stream -> 'a token stream;;
value stream_of_string : string -> char stream;;
value stream_of_channel : in_channel -> char stream;;
value print_syntax_error : unit -> unit;;
value reset_lexer : char stream -> unit;;
value string_of_token : ('a * string) list vect -> 'a token -> string;;
