(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                            inter_top.ml                                  *)
(****************************************************************************)

#open "std";;
#open "tactics";;
#open "command";;
#open "coqtoplevel";;
#open "interface";;
#open "vernac";;
#open "lexer";;

let read_loopX read_fun =
    let input_str = read_fun() in
    let str_l = break_string "." input_str in
    let new_parse = fun str () -> parse_vernac (
                                    token_stream vernac_keywords
                                    (stream_of_string str)
                                  ); 
                                  record_line str (string_length str) in
    let parse_command =
      fun str -> if (skip_space_return str) <> "" then
        (set_record Delayed; (* standard option : we record in sequence *)
         let new_str = if last_n_string 1 str = "\n"
                       then first_n_string ((length_string str) - 1) str
                       else str in
         loop_handler (new_parse (new_str ^ ".\n")) (fun () -> ()) ()) in
    do_list parse_command str_l;;

let main_loopX read_fun write_fun =
    read_loopX read_fun;write_fun();;


let constr_loopX read_fun write_fun = 
    while true do main_loopX read_fun write_fun done;;

let goX dname =
    let (read_fun, write_fun, end_fun) = open_interface dname 
    in (try constr_loopX read_fun write_fun
         with QuitX -> ()
            | Exit -> ()
            | Drop -> ()
            | End_of_file -> ()
            | reraise -> (end_fun(); raise(reraise)));
        end_fun();;

let X () = goX "";;
forward_goX.v <- goX;;
