(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             initial.mli                                  *)
(****************************************************************************)
#open "stdpp";;

type identifier = IDENT of string * int;;

type name = Name of identifier | Anonymous;;
type level = Object | Proof;;
value error : string -> 'a;;
value warning : string -> unit;;
value anomaly : string -> 'a;;
value make_silent : bool -> unit;;
value is_silent : unit -> bool;;
value make_focus : int -> unit;;
value focus : unit -> int;;
value le_level : level -> level -> bool;;
value for_all2eq : ('a -> 'b -> bool) -> 'a list -> 'b list -> bool;;
value next_ident_away : identifier -> identifier list -> identifier;;
value next_name_away : name -> identifier list -> identifier;;
value repeat_action : int -> (unit -> 'a) -> unit;;

exception UserError of string;; (* User errors *)
exception Anomaly of string;;  (* System errors *)

value explode_id : identifier -> string list;;
value print_id : identifier -> std_ppcmds;;
value string_of_id : identifier -> string;;
value id_of_string : string -> identifier;;
value stringpart_of_id : identifier -> string;;
value index_of_id : identifier -> int;;
