(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             include.ml                                   *)
(****************************************************************************)
(*
  To use the toplevel:
      $ camllight
      #include "include";;
  And with the line editor:
      $ ../../../../LEDIT/ledit -h ~/.coq.history -c camllight
      #include "include";;
 *)
#directory "../LIB/libc";;
#directory "../LIB/stream-pp";;
#directory "../LIB/librt/rt";;

#open "pp_control";;
#open "pp";;
#open "stdpp";;
#open "std";;
#open "initial";;
#open "univ";;
#open "termfw";;
#open "extraction";;
#open "term";;
#open "more_util";;
(* #open "listset";; *)
(* #open "listmap";; *)
#open "genterm";;
#open "gen_command";;
#open "gentermio";;
#open "printer";;
#open "search";;
#open "machine";;
#open "pretty";;
#open "command";;
#open "matching";;
#open "trad";;
#open "tactics";;
#open "program";;
#open "print_program";;
#open "annote";;
#open "verify";;
#open "lexer";;
#open "vernac";;
#open "coqtoplevel";;
#open "fmlterm";;
#open "fwfomatch";;
#open "fwtofml";;
#open "fmlenv";;
#open "lazy";;
#open "compile";;
#open "optimise";;
#open "caml";;
#open "coq";;
#open "xgo";;

#open "interface";;
#open "inter_top";;

trace "load_object";;
load_object "prelude";;
load_object "funqueue";;
load_object "impqueue";;
load_object "pp_control";;
load_object "pp";;
load_object "stdpp";;
load_object "std";;
load_object "initial";;
load_object "univ";;
load_object "termfw";;
load_object "extraction";;
load_object "term";;
load_object "more_util";;
load_object "listset";;
load_object "listmap";;
load_object "genterm";;
load_object "gen_command";;
load_object "gentermio";;
load_object "printer";;
load_object "search";;
load_object "machine";;
load_object "pretty";;
load_object "command";;
load_object "matching";;
load_object "trad";;
load_object "tactics";;
load_object "program";;
load_object "print_program";;
load_object "annote";;
load_object "verify";;
load_object "lexer";;
load_object "fmlterm";;
load_object "fwfomatch";;
load_object "fwtofml";;
load_object "fmlenv";;
load_object "lazy";;
load_object "compile";;
load_object "vernac";;
load_object "coqtoplevel";;
load_object "coq";;
load_object "optimise";;
load_object "caml";;

load_object "interface";;
load_object "inter_top";;

add_path ".";;
intern_state "state";;
reset_initial();;

let with_tokens f s =
    let ts = token_stream vernac_keywords (stream_of_string s) in
        f ts
;;

let ppterm0 = (fun x -> PPNL(term0 [] x));;

new_printer "constr" ppterm0;;

let ppfterm = (fun x -> PPNL(fterm0 [] x));;

new_printer "fterm" ppfterm;;

let ppannote = (fun x -> PPNL(annote0 [] x));;

new_printer "annote" ppannote;;

let parse_annote = with_tokens annotation;;

let parse_fterm = with_tokens command;;

