(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                           gen_command.ml                                 *)
(****************************************************************************)
#open "std";;
#open "univ";;
#open "initial";;
#open "extraction";;
#open "initial";;
#open "term";;
#open "termfw";;
#open "more_util";;
#open "genterm";;
#open "command";;

let rec gen_cmd = function
    (RefC id) -> (VAR id)
  | (PropC c) -> OP("PROP",[CONTENTS c],[])
  | (TypeC c) -> OP("TYPE",[CONTENTS c],[])
  | (AppC(l,r)) -> OP("APP",[],[gen_cmd l;gen_cmd r])
  | (LambdaC(bid,ty,body)) ->
    OP("LAMBDA",[],[gen_cmd ty;SLAM([SOME bid],gen_cmd body)])
  | (ProdC(bid,dom,rang)) ->
    OP("PROD",[],[gen_cmd dom;SLAM([SOME bid],gen_cmd rang)])
  | (ArrowC(dom,rang)) ->
    OP("PROD",[],[gen_cmd dom;SLAM([NONE],gen_cmd rang)])
  | (ConstrC(n,c)) -> OP("CONSTR",[INT n],[gen_cmd c])
  | (IndC(stamp,bid,a,l)) ->
    OP("IND",[NAME stamp],[gen_cmd a;
                 SLAM([SOME bid],
                      OP("CONSTRUCTORS",[],
                         map gen_cmd l))])
  | (ElimC(c,P)) -> OP("ELIM",[],[gen_cmd c;gen_cmd P])
  | (LetC(bid,M,Body)) ->
    OP("LET",[],[gen_cmd M;
                 SLAM([SOME bid],gen_cmd Body)])
  | ElimCnodep _ -> anomaly "gen_cmd: constructor ElimCnodep should never occur"
  | ElimCdep _ -> anomaly "gen_cmd: constructor ElimCdep should never occur"
;;
