(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             fmlterm.mli                                  *)
(****************************************************************************)
#open "pp";;
#open "stdpp";;

type Ext =
     Num of int
    |Plus
    |Minus
    |Times
    |Div
    |Exp
    |Lesser
    |int_elim
    |Equal
    |True
    |False
    |If                                 ;;

type fmlterm =
        Fmlambda of string * fmlterm
      | Fmapp of fmlterm * fmlterm
      | Fmvar of string
      | Fmconstruct of int * string * fmlterm list
      | Fmconst of string
      | Fmext of Ext
      | Fmrec
      | Fmarg
      | Fmerror
      | Fmlocal of string * fmlterm * fmlterm
      | FmRec of fmlterm
      | Fmmatch of fmlterm * string * (int * (string list) * fmlterm) list
      | Fmexcept of fmlterm * fmlterm;;


type transfa = Noreca |  Reca of fmlterm ;; (* (Fmrec Fmarg) if A = X *)

type fmind == string * (string * (transfa list)) list;;

type fmltype = FmLambda of string * fmltype
             | FmInd of string * (string * (fmltype list)) list
             | FmApp of fmltype * fmltype
             | FmArr of fmltype * fmltype
             | FmVar of string
             | FmConst of string
             | FmError of string
                                    ;;

value Prfmlterm : fmlterm -> std_ppcmds
  and Prfmltype : fmltype -> std_ppcmds
  and Fmindenv  : fmind list ref
  and LMLextinfix : (Ext * string) list ref
;;
