(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                            fmlterm.ml                                    *)
(****************************************************************************)

#open "std";;
#open "more_util";;
#open "printer";;
#open "initial";;
#open "pp";;
#open "stdpp";;

let max_line_length = 70;;

(***************************************************************************)
(* nFML : langage destine a l'etude et l'execution de programmes specifies *)
(*                    dans le Calcul des Constructions                     *)
(***************************************************************************)
(***************************************************************************)
(*        Definition de la structure destinee a coder les objets   ML      *)
(***************************************************************************)

(*
type Ext =
     Num of int
    |Plus
    |Minus
    |Times
    |Div
    |Exp
    |Lesser
    |int_elim
    |Equal
    |True
    |False
    |If                                 ;;
*)

let LMLextinfix = ref  [(Plus,"+");
                        (Minus,"-");
                        (Times,"*");
                        (Div,"/");
                        (Lesser,"<");
                        (Exp,"^");
                        (Equal,"=")]
                                    ;;

(***************************************************************************)
(*              Definition de la structure des objets du langage           *)
(***************************************************************************)


(*
type fmlterm =
        Fmlambda of string * fmlterm
      | Fmapp of fmlterm * fmlterm
      | Fmvar of string
      | Fmconstruct of int * string * fmlterm list
      | Fmconst of string
      | Fmext of Ext
      | Fmrec
      | Fmarg
      | Fmerror
      | Fmlocal of string * fmlterm * fmlterm
      | FmRec of fmlterm
      | Fmmatch of fmlterm * string * (int * (string list) * fmlterm) list
      | Fmexcept of fmlterm * fmlterm;;


type transfa = Noreca |  Reca of fmlterm ;; (* (Fmrec Fmarg) if A = X *)

type fmind == string * (string * (transfa list)) list;;

type fmltype = FmLambda of string * fmltype
             | FmInd of string * (string * (fmltype list)) list
             | FmApp of fmltype * fmltype
             | FmArr of fmltype * fmltype
             | FmVar of string
             | FmConst of string
             | FmError
                                    ;;
*)

let Fmindenv = ref ([]: fmind list);;

let rec Prfmlterm = function
    (Fmapp(Fmapp(((Fmext E) as tE),t1),t2))->
    if mem_assoc E !LMLextinfix then
        HOV 0
        [< 'S"("; Prfmlterm t1; 'S(assoc E !LMLextinfix);
         Prfmlterm t2; 'S")" >]
    else HOV 0
        [< Prfmlterm tE; 'SPC; Prfmlterm t1; 'SPC;
         Prfmlterm t2 >]

      | Fmapp(Fmapp(Fmapp(Fmext(If),b),t1),t2) ->
        HOV 0 [< 'S "if"; 'BRK(2,1);Prfmlterm b; 'BRK(2,1);
               HOV 0 [< 'S "then"; 'BRK(2,1); Prfmlterm t1 >];
               'SPC;
               HOV 0 [< 'S "else"; 'BRK(2,1); Prfmlterm t2 >]
              >]

      | (Fmlambda (s,t)) ->
        HOV 0
        [< 'S "["; 'ID s; 'S "]";
         'BRK(0,1); Prfmllambda t >]

      | (Fmapp (t1,t2)) ->
        HOV 0
        [< 'S"("; Prfmlapp t1;
         '(if (match t1 with
               (Fmapp(_,_)) -> true
             | _ -> false)
               then BRK(1,0) else BRK(1,3));
         Prfmlterm t2; 'S")" >]

        | (Fmvar s) -> HOV 0 [< 'ID s >]

        | (Fmconst s) -> HOV 0 [< 'ID s >]

        | (Fmconstruct (n,s,[])) ->
          HOV 0 [< 'S "Constr{";
                 'INT n; 'S ",";
                 'ID s; 'S "}" >]

        | (Fmconstruct (n,s,tl)) ->
          HOV 0 [< 'S "Constr{";
                 'INT n; 'S ",";
                 'ID s; 'S "}<";
                 Prfmluplet tl;
                 'S ">" >]

        | (Fmext E) -> Prfmlext E

        | (Fmerror) -> HOV 0 [< 'S "#Exit" >]

        | (Fmlocal(s,(FmRec t1),t2)) ->
          HOV 0 [< HOV 0 [< 'S "let rec "; 'ID s; 
                          'S " =" >];
                 'BRK(1,3);
                 HOV 0 [< Prfmlterm t1 >]; 'SPC;
                 'S " in ";
                 HOV 0 [< Prfmlterm t2 >]
                >]

        | (Fmlocal(s,t1,t2))  ->
          HOV 0 [< HOV 0 [< 'S "let "; 'ID s;
                          'S " =" >]; 'BRK(1,3);
                 HOV 0 [< Prfmlterm t1 >];
                 'SPC;
                 'S " in ";
                 HOV 0 [< Prfmlterm t2 >] >]

        | (Fmrec) -> HOV 0 [< 'S "Fmrec" >]  (* a corriger *)

        | (Fmarg) -> HOV 0 [< 'S "Fmarg" >]

        | (FmRec t) -> HOV 0 [< 'S"REC"; 'SPC; Prfmlterm t >]

        | (Fmmatch(t,s,pl)) ->
          HOV 0
          [< HOV 1
           [< 'S"match"; 'SPC; Prfmlterm t; 'SPC; 'S"with";
            'FNL >];
           HOV 0 [< Prfmlpat_list (s,pl) >];
           'S"end match" >]

        | Fmexcept(t1,t2) ->
          HOV 0 [< 'S"Try";
                 HOV 0 [< Prfmlterm t1 >];
                 'S"With"; HOV 0 [< Prfmlterm t2 >] >]

and Prfmlpat  = function
          (s,(n,[],t)) ->
          HOV 0 [< 'S(fst(nth(assoc s !Fmindenv) n));
                 'S" -> "; Prfmlterm t >]

        | (s,(n,vl,t)) ->
          HOV 0 [< 'S"("; 'S(fst(nth(assoc s !Fmindenv) n));
                 Prstrlist vl; 'S") ->"; 'SPC; Prfmlterm t >]

and Prstrlist = function
          [] -> HOV 0 [< 'S "" >]
        | (s::l) -> HOV 0 [< 'S " "; 'ID s; Prstrlist l;'CUT >]

and Prfmlpat_list = function
          (s,[p]) -> HOV 0 [< 'S " ";Prfmlpat (s,p); 'FNL >]
        | (s,(p::pl)) ->
          HOV 0 [< HOV 0 [< 'S " ";'S " ";Prfmlpat (s,p); 'FNL >];
                 HOV 0 [< Prfmlpat_list1 (s,pl) >] >]
        |  _ -> anomaly "Printer Prfmlpat_list"

and Prfmlpat_list1  = function
          (s,[]) -> HOV 0 [< 'S "" >]
        | (s,(p::pl)) ->
          HOV 0
          [< HOV 0
           [< 'S"|"; 'S " "; Prfmlpat (s,p); 'FNL >];
           HOV 0 [< Prfmlpat_list1(s,pl) >]
          >]

and Prfmlapp = function
          (Fmapp (t1,t2)) ->
          HOV 0 [< Prfmlapp t1;
                 '(if (match t1 with
                       (Fmapp(_,_)) -> true
                     | _ -> false)
                       then  BRK(1,0) else BRK(1,3));
                 Prfmlterm t2 >]
        | t -> HOV 0 [< Prfmlterm t >]

and Prfmllambda = function
    (Fmlambda (s,t)) ->
    HOV 0 [< 'S "["; 'S s; 'S "]";
           'BRK(0,1); Prfmllambda t >]
  | t -> HOV 0 [< Prfmlterm t >]

and Prfmltermlist = function
    [] -> HOV 0 [< 'S "" >]
  | (t::tl) -> HOV 0 [< Prfmlterm t; 'CUT; Prfmltermlist tl >]

and Prfmluplet = function
    [] -> HOV 0 [< 'S "" >]
  | (t::[]) -> HOV 0 [< Prfmlterm t >]
  | (t::tl) -> HOV 0 [< Prfmlterm t; 'S ","; 'CUT; Prfmluplet tl >]

and Prfmlext = function
          Plus -> HOV 0 [< 'S "Plus" >]
        | Minus -> HOV 0 [< 'S "Minus" >]
        | Times -> HOV 0 [< 'S "Times" >]
        | Lesser -> HOV 0 [< 'S "Lesser" >]
        | Equal -> HOV 0 [< 'S "Equal" >]
        | True -> HOV 0 [< 'S "True" >]
        | False -> HOV 0 [< 'S "False" >]
        | If -> HOV 0 [< 'S "If_EXT" >]
        | (Num n) -> HOV 0 [< 'INT n >]
        | _ -> anomaly "Incomplete Printer Prfmlexp" ;;

let rec Prfmltype = function
    (FmLambda (s,t)) ->
    HOV 0 [< 'S s; 'S " "; Prfmltype t >]
  | t -> HOV 0 [< 'S " == "; Prfmltyp1 t >]

and Prfmltyp1 = function
    (FmConst s) -> HOV 0 [< 'S" "; 'S s >]
  | (FmVar s) -> HOV 0 [< 'S " "; 'S s >]
  | (FmArr ((FmConst s),t2)) ->
    HOV 0 [< 'S s; 'S " -> "; 'SPC; Prfmltyp1 t2 >]
  | (FmArr ((FmVar s),t2)) ->
    HOV 0 [< 'S s; 'S " -> "; 'SPC; Prfmltyp1 t2 >]
  | (FmArr (t1,t2)) ->
   HOV 0 [< 'S " ("; Prfmltyp1 t1; 
          'S ") ->"; 'SPC; Prfmltyp1 t2 >]

  | (FmApp (t1,t2)) ->
    HOV 0 [< 'S " ("; Prfmltyp1 t1;
           'SPC; Prfmltyp1 t2; 'CUT; 'S ")" >]

  | (FmInd (s,[])) -> error "Empty Inductive Sets do not make sense in Fml, even if they do in Coq"

  | (FmInd (s,[s1,tl])) ->
    HOV 0 [< 'S "inductive"; 'SPC; 'S s1; 'S" ";
           'SPC; prlist Prfmltyp1 tl >]

  | (FmInd (s,((s1,tl)::cl))) ->
    HOV 0 [< 'S "inductive"; 'FNL; 
           'S s1; 'S" "; 'SPC; prlist Prfmltyp1 tl; 'SPC;
           prlist Prfmlconstr cl >]

        | FmError s -> anomaly ("Incomplete Printer Prfmltyp1 - probably because type "^s^" was not instantiated")

  | (FmLambda _) -> error "Embedded type-lambdas in Fml types do not make sense"

and Prfmlconstr = function
    (s,tl) ->
    HOV 0 [< 'S "| "; 'S s; prlist Prfmltyp1 tl;  'SPC >]
;;



