(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              fmlenv.ml                                   *)
(****************************************************************************)

#open "std";;
#open "initial";;
#open "term";;
#open "extraction";;
#open "machine";;
#open "termfw";;
#open "fmlterm";;
#open "fwtofml";;

let Fmtypenv = ref ([]:(string * fmltype) list);;

let add_fmltype s c = Fmtypenv:= (s,c)::!Fmtypenv;;

let Fmenv = ref ([]:(string * fmlterm) list);;

let add_fml s c = Fmenv:= (s,c)::!Fmenv;;

let fm_reset_all () = Fmtypenv:=[]; Fmenv:=[]; reset_fmind(); fwfomatch__reset_indtypes();fwfomatch__reset_renamings();();;

exception NotTranslatable1 of string;;
exception NotTranslatable2 of string;;

let rec extract_cont_typ lc = function
    [] -> ()
  | (Vardecl(Decl(Name(s),Judge(_,_,Object),Inf(_,_)),_,_),_)::l
          ->  extract_cont_typ [] l; 
              (try add_fmltype (string_of_id s) (fwtofmlvartype (string_of_id s)); ()
                with NotTranslatable -> raise(NotTranslatable1 (string_of_id s))
                   | reraise -> raise(reraise))
  | (Constdecl(Def(Name(s),Judge(_,_,Object),Inf(_,(Fconst _ as fc))),_,_),_)::l ->
        extract_cont_typ [] l;
        let (Fconst(_,f)) = fwfomatch__process_type fc in
        (try
         (if isind_weak f then let c = fwtofmlind (string_of_id s) lc f
                          in (add_fmind (makefmind c); add_fmltype (string_of_id s) c;())
          else (add_fmltype (string_of_id s) (fwtofmlabbr f); ()))
        with
             NotTranslatable -> raise (NotTranslatable1 (string_of_id s))
                   | reraise -> raise(reraise))
  | (Constdecl(Def(Name(s),Judge(_,_,Proof),Inf(_,f)),_,_),_)::l ->
         if isconstr f then extract_cont_typ ((string_of_id s)::lc) l
         else  extract_cont_typ [] l
  | _::l    -> extract_cont_typ [] l;;


let rec extract_cont_term = function
     [] -> ()
  |  (Vardecl(Decl(Name(s),Judge(_,_,Proof),Inf(_,_)),_,_),_)::l
          ->  extract_cont_term l; 
              add_fml (string_of_id s) 
                     (try fwtofmlvar (string_of_id s)
                      with NotTranslatable -> raise(NotTranslatable2 (string_of_id s))
                         | reraise         -> raise(reraise));
              ()
  | (Constdecl(Def(Name(s),Judge(_,_,Proof),Inf(_,(Fconst _ as fc))),_,_),_)::l 
           ->  extract_cont_term l; 
               let (Fconst(_,f)) = fwfomatch__process_term fc in
               add_fml (string_of_id s) 
                (try fwtofmlterm f
                 with NotTranslatable -> raise (NotTranslatable2 (string_of_id s))
                     | reraise -> raise(reraise));
               ()
  | _::l    -> extract_cont_term l;;

let extract_cont m = 
    try
        extract_cont_typ [] m; extract_cont_term m
     with
            NotTranslatable1 (s) -> message ("The type "
                                            ^s
                                            ^" is not translatable")
          | NotTranslatable2 (s) -> message ("The term "
                                            ^s
                                            ^" is not translatable")

          | reraise -> raise(reraise);;

let extract_all () = extract_cont (read_context());;

let extract_all_until name = 
    let (_,l) = chop_context name (read_context()) in extract_cont l;;

let extract_from name = let (l,_) = chop_context name (read_context()) in
      extract_cont (rev l);;

let extract_from_to name2 name1 =
  let (_,l) = chop_context name1 (read_context()) in 
  let (m,_) = chop_context name2 l in extract_cont (rev m);;

(* The last theorem of the initial environment *)
let last_id_initial = id_of_string "well_founded_induction";;
 
let extract_until name = extract_from_to last_id_initial name;;
 
let fm_reset () = fm_reset_all (); extract_all_until last_id_initial;;

