(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                           extraction.mli                                 *)
(****************************************************************************)

#open "termfw";;
#open "initial";;

type contents = Pos | Null | Data;;

type nature = Fw | Extracted;;
type information = Logic | Inf of nature * fterm;;

type compatibility = Comp of fterm | Error | Invar;;

value compat : level -> nature -> level -> information -> compatibility;;

value inf_const : name -> information -> information;;
value inf_var : name -> information -> information;;
value inf_value : information -> information;;
value inf_vartype : information -> information;;
value inf_kind : contents -> information;;
value inf_apply : level -> level -> information -> information -> information;;
value inf_replace : identifier -> information -> information -> information;;
value inf_abs_var : level -> level -> information -> information -> information;;
value inf_generalize : level -> level -> information -> information -> information;;
value inf_gen_rel : level -> level -> information -> information -> information;;
value inf_abs_rel : level -> level -> information -> information -> information;;
value inf_rel : int -> information -> information;;
value inf_abs_apply : level -> level -> information -> information -> information * information;;
value inf_gen_apply : level -> level -> information -> information -> information * information;;
value is_fw : information -> bool;;
value is_informative : information -> bool;;
value logic : unit -> information;;
value abstract_inf : name -> information -> information;;
value inf_indtype : name -> information -> information list -> information;;
value inf_indconstr : information -> int -> information;;
value inf_make_elim : information -> contents -> information;;
value inf_make_const : identifier -> information -> information;;
value inf_make_elimination : information -> information -> information;;
value inf_inst_elim : information list -> information -> information;;
