#open "std";;
#open "initial";;
#open "extraction";;
#open "term";;
#open "machine";;
#open "tactics";;



(*******************************)
(* Some changes to do in the future:
  1) the function that makes the difference between two elements of the type
     is built every time the tactic is called. I think that it will be
     better to generate it once and associate  a name to it, and to call
     the function already generated.
  2) the tactics are generally simple and are not expected to be intelligent,
     the idea is that the user has to do all by little steps. Well, discrimi
     nate is not like that, it expects a goal of the form:
       (x1:T1)...(xn:Tn)~(<T>t1=t2)
     where t1 and t2 should REDUCE to terms which are built from different
     constructors. Gilles told me that should not reduce, then the expected
     tactic should be something of the form
        (x1:T1)...(xn:Tn)~(<T>constr_i(...)=constr_j(...)) where constr_i
     and constr_j are two constructors of the type T. I don't know if it
     should be even simpler than that and expect a goal of the form:
                constr_i(...)=constr_j(...))
     and the user is expected to do the intros before calling the tactic.

 I will do these changes after.

*)
(********************************)



(*Function generation*) 
(*-------------------*)

(* Auxiliares *)


(* associates to the constant str the correspondant construction in the
   context
*)

let meaning_of str =
let v = search (id_of_string str)
in let (Constdecl (w,_,_)) = v
in Const w;;






(* ofsort_set: determines weather a given an arity, is of sort Set or not *)
let rec  ofsort_set = function 
     Prod (v, t, c) -> (ofsort_set c)
   | Prop (Pos)     -> true
   |   _            -> false;;

exception Unadequate_arg of int;;
exception Notarity of string;;


(* to_Prop (a1:T1)...(an:Tn)s = (a1:T1)...(an:Tn)Prop  *)
let rec to_Prop = function 
      (Prop(Null) as x)   -> x         (* input is of sort Prop *)
   |  Prop(Pos)           -> Prop Null  (* input is of sort Set  *)
   |  Type(_)             -> Prop Null  (* input is of sort Type *)
   |  Prod(v,t,c)         -> Prod (v,t,(to_Prop c))
   |   _                  -> raise (Notarity "Not an arity");;



(*
 transf (a1:T1)...(an:Tn)s = [a1:T1]...[an:Tn]Prop
*)  
let rec transf = function
     (Prop(Null) as x )  -> x          (* input is of sort Prop *)
   |  Prop(Pos)          -> Prop Null  (* input is of sort Set  *)
   |  Type(_)            -> Prop Null  (* input is of sort Type *)
   |  Prod(v,t,c)        -> Lambda (Anonymous,t, (transf c))
   |     _               -> raise (Notarity "Not an arity");;



(* determines if var Rel(n) occurs in c *)

let num_occurs n c = num_occ_rec 1 c
 where rec num_occ_rec m =  function
        Rel(p)          -> (n=m) & (p=n)
      | App(c,c')       -> (num_occ_rec m c) or (num_occ_rec m c')
      | Lambda(_,c,c')  -> (num_occ_rec m c) or (num_occ_rec (m+1) c')
      | Prod (_,c,c')   -> (num_occ_rec m c) or (num_occ_rec (m+1) c')
      |    _            ->  false;;


(* sv_subst builds from the type elimination scheme  constr an appropiete 
function to pass to the elimator scheme. sv_subst transform products in lambdas
and substitutes de first free variable (ie: lower index) by sort and the function it generates
returns val
Example: constr = (n:nat)Rel(4)->(Rel(4) n)->(y n)->(y (S n)) "here y=Rel(4)"
         sort = [n:nat]Prop
         val = Tue
[n:nat][Anonymous:Rel(4)][Anonymous:(Rel(4) n)][Anonymous:sort]val
                                                          ---  ---
*)

let rec sv_subst constr n sort val =
  match  constr  with
    (Rel (m)) ->  if m=n then sort else Rel(m)

  |(Prod (v,t,c)) -> 
      begin match  c  with
        (Rel (p)) ->if p=(n+1) 
                       then Lambda (v, (sv_subst t n sort val), val)
                       else raise (Unadequate_arg (1)) 
                        (*"Not an elimination type"*)
      | (App (o,a)) -> Lambda (v, (sv_subst t n sort val), val)
      | _           -> Lambda (v, (sv_subst t n sort val),
                                  (sv_subst c (n+1) sort val))
             
      end

  | (Lambda(v, t, c)) -> 
       begin match  c  with
         (Rel (p)) -> if p=n+1 
                         then val
                         else raise (Unadequate_arg (2))
                            (*" Not an elimination type"*)
       | (App (o,a)) -> Lambda (v, (sv_subst t n sort val), val)
       | _ -> Lambda (v, (sv_subst t n sort val),
                                 (sv_subst c (n+1) sort val))
       end
                
  | (App (o,a)) ->  App ( (sv_subst o n sort val), (sv_subst a n sort val))

  | x -> x ;;




(* num_of_dep (x1:M1)...(xn:Mn)s = n+1  *)

let rec num_of_dep arity =
   match arity with
      (Prop(_)) -> 1
   |  (Type(_)) -> 1
   |  (Prod(_,_,c)) -> 1 + num_of_dep c;;



(* Given an elimination type scheme e, a value val,an inductive type ti of the
   canonical form Ind(..){..} and the original inductive type oit,
   Instantiate builds an elimination function that corresponds to the scheme
   e that returns val as result. Instantiate preserves constants.
   Formally:
        Instantiate [y:.](e1:P1)...(er:Pr)(y a1...am) val 
                    Ind(X:(x1:M1)...(xm:Mm)s){..} oit =
        [e1:P1]...[er:Pr]val <[.:m1]...[.:Mm]Prop/y><oit/x>
   
   where  e<E/v> denotes the substitution of v by E in e.
   

  WARNING: ti has to be of the form Ind(...){..}. If you have a parametric type
  you have to destruct before calling Instantiate.

  Remarq: In the code of Instantiate it's necessary to decrement the indexes
  after doing the substitution because the first lambda has dissapeared. This
  is always true because the minimal form of the elimination scheme is [y:.]y
  i.e at least one substitution is always done. 
 *)

let Instantiate e  val ti oit = 
  match e with
   (Lambda(y,t,c))  -> 
     begin
       match c with
         (Rel(m))  -> val        (* e=[y:.]y *)
        |(App(o,a)) -> val       (* e=[y:.](y a1...am) *)
        |   _    ->              (* e=[y:.](x1:T1)...(xn:Tn)(y a1...am)  *)
          begin
           let  (Ind(_,sort,_,_,_))=ti in
            let elim= lift (-1)  (simplify (sv_subst  c 1 (transf sort) val))
            in lift (num_of_dep sort) (subst1 oit elim) 
          end
     end
  |   _   -> raise ( Unadequate_arg (0)) (*"Not an elimination type"*);;
 
       

(* Given a list of non dependant type scheme elimination lnd, a number of
   constructor nc and an inductive type ti of the canonical form Ind(...){..}
   and the original form oit of the inductive type, build_elim builds a list 
   of functions such that each function corresponds to each type elimination 
   scheme and returns True if the elimination scheme  correspond to the 
   constructor nc (i.e is the nc-th in the list lnd) and False otherwise.
   The function receives oit and ti because we want to preserve constants.
   Remarq: build_elim searchs the construction associated to "True" and
   "False" in the environment.
*)

let   build_elim  lnd nc ti oit = build_it lnd 1
 where rec build_it lnd n = let  valT = meaning_of "True" in 
 let valF = meaning_of"False"
 in  match lnd  with
         []   ->  []
     | (e::l) -> if  n=nc 
                  then (Instantiate e  valT  ti oit):: build_it l (n+1)
                  else (Instantiate e  valF  ti oit)::build_it l (n+1);;



exception Notarity of string;;



(* given a string s and a list qu of pairs (var,type), find_name returns
   a name of the form (s,number) such that this name does not appear in qu
*)

let find_name s qu = 
  let name = IDENT(s,-1) 
  in  Name(newid_in_qu  (new_name name)  qu)
  where rec newid_in_qu name  qu=
      match qu with
           [] -> name
      | ((v,t)::r) -> match v with
                       (Name(id)) -> let (IDENT(s,n))=id 
                                     in if s=stringpart_of_id name
                                         then newid_in_qu (IDENT(s,n+1)) r
                                         else (newid_in_qu name r)
                      | _ -> (newid_in_qu name r);;
 


(* insert_dep (a1:T1)...(an:Tn)s qu = [(a1',T1);...(an':Tn)]@qu
    where ai=ai' if ai<>Anonymous and ai' is a new name otherwise
*)
let rec insert_dep a qu =
 match a with
    (Prop(_))  -> []
 |  (Type(_))  -> []
 |  (Prod(v,t,c)) -> if v <> Anonymous then (insert_dep c qu)@ [(v,t)]
                     else (insert_dep c qu)@ [((find_name "y"  qu),t)]
 |     _  ->  raise (Unadequate_arg (5)) (*"Not an arity" *);;




(* build_paramdep [A1:T1]..[An:Tn] Ind(X:(a1:L1)...(am:Lm)s){..} =
                  [(A1,T1);..;(An,Tn);(a1,L1);...;(am,Lm)]
   given an inductive type eventually parametric, build_param builds a list
   of pairs (paramater,type) correponding to the parameters and the
   dependencies of the type

*)
(* OJO!!!! no se que tiene que dar en la apicacion  *)

let build_paramdep indt = build_it indt []
 where rec build_it indt qu =
  match indt with
   (Lambda(p,t,c)) -> (p,t)::(build_it c qu)
  |(Ind(_,s,_,_,_)) -> (insert_dep s qu)
  |(Const(Def(_,Judge(c,_,_),_))) -> build_it c qu
  |(App(o,a))  -> build_it o qu
  |   _   -> raise (Unadequate_arg (4) (*Not an inductive type*));;



(* build_param  [A1:T1]..[An:Tn] Ind(..){..} =[(A1,T1);..;(An,Tn)] 
   given an inductive type eventually parametric, build_param builds a list
   of pairs (paramater,type) correponding only to the parameters
*)

let build_param indt = build_it indt []
 where rec build_it indt qu =
  match indt with
   (Lambda(p,t,c)) -> (p,t)::(build_it c qu)
  |(Ind(_,s,_,_,_)) -> qu
  |(Const(Def(_,Judge(c,_,_),_))) -> build_it c qu
  |(App(o,a))  -> build_it o qu
  |   _   -> raise (Unadequate_arg (4) (*Not an inductive type*));;



(* build_app it n = App (App(...(App(ti; Rel(n)),Rel(n-1))...)Rel(1))
   given an inductive type and the number of parameters and dependencies of
   the type buld_app builds an application of the inductive type ti to all its 
   parameters and dependencies
*)

let build_app it np = simplify (build_app_it  it np)
where rec build_app_it it np= if np=0 then it 
                              else (build_app_it  (App(it,Rel(np))) (np-1));;


 
let rec build_exp paramdep  nd nc sort cit oit =  build_exp_it paramdep
 where rec build_exp_it qu =  
 let lp = length (build_param oit)
 in match qu with
       [] -> Lambda((find_name "e" qu), (build_app oit (length paramdep)), 
                     Rec(false,(sort ::(build_elim nd nc cit 
                                         (build_app oit lp))),
                         Rel(1)))
    | ((p,t)::r) -> Lambda(p, t, build_exp_it  r);;
                 


 

let build_result param canonicty initialty nc =
match  canonicty with
 (Ind(_,s,_,_,spt)) ->
     let (Specift(_,lnd))= spt
     in  let nd=(snd lnd) and sort=( transf  s) 
            in  (build_exp param  nd nc sort canonicty initialty)
 | _ -> raise (Unadequate_arg (7) )(*Not a canical inductive type*);;
          

                                             

(* given an inductive type it and the number of a constructor nc, differentiate
   builds a function that receives an argument of type ti and returns True if
   the argument is of the form  Constr(nc,ti) and False otherwise.
   Formally:
        if ti=[A1:T1]...[An:Tn]Ind(X:(a1:M1)..(am:Mm)Set){c1|...|cp}
        differentiate ti  j = F 

    such that F: (A1:T1)...(An:Tn)(a1:M)...(am:Mm)(e:(ti A1...An a1...am))Prop
     and  (F A1...An a1...am e j) = True <==> e B-reduces to
                                                 Construct(j,(ti A1...An))
*)


let differentiate it nc =
  let  simpty= simplify it   in      (* in case it is an elimination *)
  let qu = (build_paramdep simpty)
  in make_diff  simpty it  nc
  where rec make_diff typ oit nc =
       match typ with
           (Ind(n,s,lc,spr,spt)) ->
                if not (ofsort_set s) 
                 then raise (Unadequate_arg (1) )     
                        (*"not a type of Set sort"*)
                 else if (length lc) < nc 
                       then raise (Unadequate_arg (2))
                                (*"incorrect constructor number"*)
                       else (build_result qu typ oit nc)
       |   (Lambda(p,t,c)) -> make_diff c oit nc
       |   (App(o,a)) -> App(make_diff o o nc, a) (* the original type is the
                                                    operator of the applic*)
                                                      
       |   (Const(Def(_,Judge(c,_,_),_))) ->
                  begin
                    match c with
                      (App(o,a)) -> App(make_diff o o nc, a) 
                                      (*the original type is the operator*)
                                                                
                    |  x   ->    make_diff c oit nc
                  end
       |    _   -> raise (Unadequate_arg (3))
                                 (* not an inductive type *);;






(********************************************)
(* Generation of the proof of the difference*)
(* between elements built with different    *)
(* constructors.                            *)
(********************************************)


(* given a term t constructor_of returns the constructor from which t 
   is built 
*)

let rec constructor_of t =
  match (simplify t) with
     (Construct(_))  -> t
  |  (App(o,_))   ->  constructor_of o
  |  (Const(Def(_,Judge(c,_,_),_))) -> constructor_of c
  |  (Lambda(_,_,c))-> constructor_of c
  |      _   -> raise (Unadequate_arg(15)) 
                      (* t is not an element of ind. type*);;


(* constr_dif t1 t2 = true <==> if the constructors of t1 and t2 have different
   index 
*)

let constr_dif t1 t2 =
 match (constructor_of t1) with
   (Construct(i,T1)) -> 
       begin 
        match (constructor_of t2) with
          (Construct(j,T2)) -> (i<>j) & (T1=T2)
        |   _     -> raise (Unadequate_arg(14)) 
                          (* t2 is not an element of inductive type *)
       end
  |  _  ->  raise (Unadequate_arg(15)) 
              (* t1 is not an element of inductive type *);;

  
(* given a term elem constructor_of returns the index of the  constructor 
   from which  elem  is built
*)
let rec index_of elem =
 match  (simplify elem) with   
   (Construct(i,_)) -> i      
 | (App(o,_))  ->  (index_of o)
 | (Const(Def(_,Judge(c,_,_),_))) -> index_of c
 | (Lambda(_,_,c)) -> (index_of c)
 |  _    -> raise (Unadequate_arg (13))
              (* not an element of a inductive type *);;


(* I think that gen_name takes care of the name that are in the context
   because it invoques find_name and find_name calls new_name which I
   think cares of the context. There are two functions new_name one in
   optimise and another in machine. The one I call is that of machine.ml
   (I hope!).
*)
   

(* given a string str a construction goal and a list of the form (name,index)
   gen_name generates a name of the form Name(Ident(str,n)) where n is a new
   index. 
*)

let gen_name str goal qu = find_name str qu;;


(* OJO!! los = son = o  reducciones ? *)

let app_eqind ig T t1 P  Pt1 t2 t1eqt2 =
  App(App(App(App(App(App(ig,T),t1), P), Pt1), t2), t1eqt2);;



(* Given a goal of the form (x1:T1)...(xn:Tn)~<T>t1=t2,
   it builds the term [x1:T1]...[xn:Tn][H:<T>t1=t2](eq_ind T t1 I t2 H)
   that 's a proof of the goal.
*)
let discriminate_proof goal  = 
 let eq_ind=  meaning_of "eq_ind"    and 
     valF= meaning_of "False"        and
     eq= meaning_of "eq"             and 
     I= meaning_of "I"               and 
     neg= meaning_of "not"           
 in make_proof  goal []
 where rec make_proof goal qu =
   match goal with
     (Prod(v,t,p)) ->
        begin
         match t with
           (App(App(App(e,T),t1),t2)) as eqtype ->
              if e=eq &  (constr_dif t1 t2) & p=valF  (* = o reduccion?*)
              then  let newname= gen_name "H" goal qu 
                    in Lambda(newname,eqtype,
                      (app_eqind eq_ind (lift 1 T) (lift 1 t1) 
                                (differentiate (lift 1 T) (index_of t1))
                                I  (lift 1 t2) (Rel(1)) ))
              else raise (Unadequate_arg(11)) 
                    (* not a difference of elements of inductive type *)
         |  _   ->  Lambda(v,t, make_proof p ((v,t)::qu) )
        end
     | (App(o,a)) -> if o=neg 
                    then  make_proof (Prod(Anonymous,a,valF)) qu
                    else raise( Unadequate_arg(10)) 
                                (* not a difference of constructors *)
   |  _  -> raise(Unadequate_arg(19)) 
             (* Expects a goal of the form (x1:T1)...(xn:Tn)not<T>t1=t2 *);;


let discriminate_const (_,_,goal) =
 try PF(discriminate_proof goal)   
 with  Unadequate_arg(_) -> error 
"expects a goal of the form (x1:T1)...(xn:Tn)not<T>cosntr_i(...)=constr_j(...)";;
                   



