(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             command.mli                                  *)
(****************************************************************************)
#open "initial";;
#open "extraction";;
#open "machine";;

type command =
  RefC of identifier
| PropC of contents
| TypeC of contents
| AppC of command * command
| LambdaC of identifier * command * command
| ProdC of identifier * command * command
| ArrowC of command * command
| ConstrC of int * command
| IndC of name * identifier * command * command list
| ElimCdep of command * command * command list
| ElimCnodep of command * command
| ElimC of command * command 
| LetC of identifier * command * command;;

value construct : command -> unit;;
value theorem : string -> int -> unit;;
value conjecture : command -> unit;;
value statement : command -> unit;;
value proof : command -> unit;;
value definition : string -> int -> unit;;
value body : command -> unit;;
value body_typ : command -> command -> unit;;
value hypothesis : string -> int -> unit;;
value def_var : command -> unit;;
value structural_noelim : name -> (identifier * command) list -> identifier -> command -> (identifier * command) list -> strength -> unit;;
value structural_elim : name -> (identifier * command) list -> identifier -> command -> (identifier * command) list -> strength -> unit;;

value generative_noelim : (identifier * command) list -> identifier -> command -> (identifier * command) list -> strength -> unit;;
value generative_elim : (identifier * command) list -> identifier -> command -> (identifier * command) list -> strength -> unit;;

value with_heavy_rollback : ('a -> 'b) -> 'a -> 'b;;
value with_light_rollback : ('a -> 'b) -> 'a -> 'b;;


exception Drop;;
value drop : unit -> 'a;;
