(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              varpp.mli                                   *)
(****************************************************************************)
#open "pp";;
#open "pp_control";;

type stdtoken;;

value var_fp : stdtoken pp_formatter_defaults;;

value with_depth : pp_global_defaults -> int -> unit;;
value fully_pp : pp_global_defaults -> unit;;
value full_print : stdtoken ppcmd_token stream -> unit;;

value PP : stdtoken ppcmd_token stream -> unit;;
value PPNL : stdtoken ppcmd_token stream -> unit;;

value AsNull : string -> stdtoken ppcmd_token;;
value STRING : string -> stdtoken ppcmd_token;;
value S : string -> stdtoken ppcmd_token;;
value ID : string -> stdtoken ppcmd_token;;
value QSTRING : string -> stdtoken ppcmd_token;;
value QS : string -> stdtoken ppcmd_token;;
value INT : int -> stdtoken ppcmd_token;;
value REAL : float -> stdtoken ppcmd_token;;
value BOOL : bool -> stdtoken ppcmd_token;;
