(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              varpp.ml                                    *)
(****************************************************************************)
#open "pp_control";;
#open "pp";;

type stdtoken =
    std_STRING of int * string
  | std_BOOL of bool
  | std_REAL of float
  | std_QSTRING of string
  | std_INT of int
;;

let string_of_bool = function true -> "true" | _ -> "false";;
let string_of_char = char_for_read;;

let print_stdtoken =
let ps s = (string_length s,[< 's >]) in
    function
    std_STRING(n,s) -> (n,[< 's >])
  | std_BOOL b -> ps (string_of_bool b)
  | std_REAL r -> ps (string_of_float r)
  | std_QSTRING s ->
    let sfr = string_for_read s in
        (2+(string_length sfr),[< 'sfr >])
  | std_INT n -> ps(string_of_int n)
;;

let (var_fp:stdtoken pp_formatter_defaults) =
    {output = ref (output_substring std_out);
     flush_out = ref (fun () -> flush std_out);
     print = ref print_stdtoken}
;;

let biggest_int = 1073741822;;

let with_depth gp n =
    (gp.pp_control__max_depth := n;
     if !(gp.pp_control__limit_depth) < n then
         gp.pp_control__limit_depth := succ n)
;;

let fully_pp gp = with_depth gp biggest_int;;

let full_print strm =
    let gp = copy_gp dflt_gp in
        (fully_pp gp;
         PP_WITH gp var_fp strm)
;;

let PP cmdstream = PP_WITH dflt_gp var_fp cmdstream;;
let PPNL cmdstream = PPNL_WITH dflt_gp var_fp cmdstream;;

let AsNull s = PR(std_STRING(0,s));;
let STRING s = PR(std_STRING(string_length s,s));;
let S = STRING;;
let ID id = STRING id;;
let QSTRING s = PR(std_QSTRING s);;
let QS = QSTRING;;

let INT n = PR(std_INT( n));;
let REAL r = PR(std_REAL( r));;
let BOOL b = PR(std_BOOL( b));;
