(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                              stdpp.mli                                   *)
(****************************************************************************)
#open "pp";;
#open "pp_control";;

value std_fp : (int * string) pp_formatter_defaults;;

value with_depth : pp_global_defaults -> int -> unit;;
value fully_pp : pp_global_defaults -> unit;;
value full_print : (int * string) ppcmd_token stream -> unit;;

value PPDIR : (int * string) ppdir_token stream -> unit;;
value PPDIR_FULL : (int * string) ppdir_token stream -> unit;;
value PP : (int * string) ppcmd_token stream -> unit;;
value PPNL : (int * string) ppcmd_token stream -> unit;;

value AsNull : 'a -> (int * 'a) ppcmd_token;;
value STRING : string -> (int * string) ppcmd_token;;
value S : string -> (int * string) ppcmd_token;;
value ID : string -> (int * string) ppcmd_token;;
value QSTRING : string -> (int * string) ppcmd_token;;
value QS : string -> (int * string) ppcmd_token;;
value INT : int -> (int * string) ppcmd_token;;
value REAL : float -> (int * string) ppcmd_token;;
value BOOL : bool -> (int * string) ppcmd_token;;

type std_ppcmds == (int * string) ppcmds;;
type std_ppdirs == (int * string) ppdirs;;
