(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                             stdpp.ml                                     *)
(****************************************************************************)
#open "pp_control";;
#open "pp";;

let string_of_bool = function true -> "true" | _ -> "false";;
let string_of_char = char_for_read;;

let (std_fp:(int * string) pp_formatter_defaults) =
    {output = ref (output_substring std_out);
     flush_out = ref (fun () -> flush std_out);
     print = ref (function (n,s) -> (n,[< 's >]))}
;;

let biggest_int = 1073741822;;

let with_depth gp n =
    (gp.pp_control__max_depth := n;
     if !(gp.pp_control__limit_depth) < n then
         gp.pp_control__limit_depth := succ n)
;;

let fully_pp gp = with_depth gp biggest_int;;

let full_print strm =
    let gp = copy_gp dflt_gp in
        (fully_pp gp;
         PP_WITH gp std_fp strm)
;;

let PP cmdstream = PP_WITH dflt_gp std_fp cmdstream;;
let PPNL cmdstream = PPNL_WITH dflt_gp std_fp cmdstream;;

let PPDIR dirstream = PPDIR_WITH  dflt_gp std_fp dirstream;;

let PPDIR_FULL dirstream =
    let gp = copy_gp dflt_gp in
        (fully_pp gp;
         PPDIR_WITH gp std_fp dirstream)
;;

let AsNull s = PR(0,s);;
let STRING s = PR(string_length s,s);;
let S = STRING;;
let ID id = STRING id;;
let QSTRING s = STRING(string_for_read s);;
let QS = QSTRING;;

let INT n = STRING(string_of_int n);;
let REAL r = STRING(string_of_float r);;
let BOOL b = STRING(string_of_bool b);;
